/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EyeSwitchBlock
extends HorizontalDirectionalBlock {
    public static final BooleanProperty POWERED = BooleanProperty.m_61465_((String)"powered");
    private final VoxelShape NORTH_AABB;
    private final VoxelShape EAST_AABB;
    private final VoxelShape SOUTH_AABB;
    private final VoxelShape WEST_AABB;

    public EyeSwitchBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        ((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false));
        this.NORTH_AABB = this.makeShape();
        this.EAST_AABB = this.rotateShape(this.NORTH_AABB, Direction.EAST);
        this.SOUTH_AABB = this.rotateShape(this.NORTH_AABB, Direction.SOUTH);
        this.WEST_AABB = this.rotateShape(this.NORTH_AABB, Direction.WEST);
    }

    public static boolean canAttach(LevelReader pReader, BlockPos pPos, Direction pDirection) {
        BlockPos blockpos = pPos.m_121945_(pDirection);
        return pReader.m_8055_(blockpos).m_60783_((BlockGetter)pReader, blockpos, pDirection);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{POWERED, f_54117_});
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)pContext.m_8125_())).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction facing = (Direction)pState.m_61143_((Property)f_54117_);
        switch (facing) {
            case EAST: {
                return this.EAST_AABB;
            }
            case SOUTH: {
                return this.SOUTH_AABB;
            }
            case WEST: {
                return this.WEST_AABB;
            }
        }
        return this.NORTH_AABB;
    }

    public VoxelShape makeShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.46875, (double)0.03125, (double)0.0, (double)0.53125, (double)0.96875, (double)0.0625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.4375, (double)0.0625, (double)0.0, (double)0.46875, (double)0.9375, (double)0.0625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.53125, (double)0.0625, (double)0.0, (double)0.5625, (double)0.9375, (double)0.0625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.40625, (double)0.0625, (double)0.0, (double)0.4375, (double)0.90625, (double)0.0625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.5625, (double)0.0625, (double)0.0, (double)0.59375, (double)0.90625, (double)0.0625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.375, (double)0.125, (double)0.0, (double)0.40625, (double)0.875, (double)0.0625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.59375, (double)0.125, (double)0.0, (double)0.625, (double)0.875, (double)0.0625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.34375, (double)0.15625, (double)0.0, (double)0.375, (double)0.84375, (double)0.0625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.625, (double)0.15625, (double)0.0, (double)0.65625, (double)0.84375, (double)0.0625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.3125, (double)0.15625, (double)0.0, (double)0.34375, (double)0.8125, (double)0.0625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.65625, (double)0.15625, (double)0.0, (double)0.6875, (double)0.8125, (double)0.0625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.28125, (double)0.21875, (double)0.0, (double)0.3125, (double)0.78125, (double)0.0625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.6875, (double)0.21875, (double)0.0, (double)0.71875, (double)0.78125, (double)0.0625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.25, (double)0.0, (double)0.28125, (double)0.75, (double)0.0625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.71875, (double)0.25, (double)0.0, (double)0.75, (double)0.75, (double)0.0625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.21875, (double)0.28125, (double)0.0, (double)0.25, (double)0.71875, (double)0.0625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.75, (double)0.28125, (double)0.0, (double)0.78125, (double)0.71875, (double)0.0625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.3125, (double)0.0, (double)0.21875, (double)0.6875, (double)0.0625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.78125, (double)0.3125, (double)0.0, (double)0.8125, (double)0.6875, (double)0.0625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.15625, (double)0.34375, (double)0.0, (double)0.1875, (double)0.65625, (double)0.0625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.8125, (double)0.34375, (double)0.0, (double)0.84375, (double)0.65625, (double)0.0625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.375, (double)0.0, (double)0.15625, (double)0.625, (double)0.0625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.84375, (double)0.375, (double)0.0, (double)0.875, (double)0.625, (double)0.0625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.09375, (double)0.40625, (double)0.0, (double)0.125, (double)0.59375, (double)0.0625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.875, (double)0.40625, (double)0.0, (double)0.90625, (double)0.59375, (double)0.0625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.4375, (double)0.0, (double)0.09375, (double)0.5625, (double)0.0625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.90625, (double)0.4375, (double)0.0, (double)0.9375, (double)0.5625, (double)0.0625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.03125, (double)0.46875, (double)0.0, (double)0.0625, (double)0.53125, (double)0.0625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.9375, (double)0.46875, (double)0.0, (double)0.96875, (double)0.53125, (double)0.0625), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    private VoxelShape rotateShape(VoxelShape shape, Direction direction) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (direction.m_122416_() - Direction.NORTH.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    public int m_6378_(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        return (Boolean)pBlockState.m_61143_((Property)POWERED) != false ? 15 : 0;
    }

    public int m_6376_(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        return (Boolean)pBlockState.m_61143_((Property)POWERED) != false && ((Direction)pBlockState.m_61143_((Property)f_54117_)).m_122424_() == pSide ? 15 : 0;
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pMovedByPiston) {
        super.m_6807_(pState, pLevel, pPos, pOldState, pMovedByPiston);
        this.updateNeighbours(pState, pLevel, pPos);
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        super.m_6810_(pState, pLevel, pPos, pNewState, pMovedByPiston);
        this.updateNeighbours(pState, pLevel, pPos);
    }

    private void updateNeighbours(BlockState pState, Level pLevel, BlockPos pPos) {
        pLevel.m_46672_(pPos, (Block)this);
        pLevel.m_46672_(pPos.m_121945_((Direction)pState.m_61143_((Property)f_54117_)), (Block)this);
    }

    public boolean m_7899_(BlockState pState) {
        return true;
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return EyeSwitchBlock.canAttach(pLevel, pPos, (Direction)pState.m_61143_((Property)f_54117_));
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, level, pos, neighbor);
        this.m_7898_(state, level, pos);
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return pState.m_61143_((Property)f_54117_) == pFacing && !pState.m_60710_((LevelReader)pLevel, pCurrentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public void m_5581_(Level pLevel, BlockState pState, BlockHitResult pHit, Projectile pProjectile) {
        if (!pLevel.f_46443_ && pProjectile instanceof Arrow) {
            boolean powered = (Boolean)pState.m_61143_((Property)POWERED);
            BlockState newState = (BlockState)pState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(!powered));
            pLevel.m_7731_(pHit.m_82425_(), newState, 3);
            pLevel.m_46672_(pHit.m_82425_(), (Block)this);
            BlockPos neighborPos = pHit.m_82425_().m_121945_((Direction)newState.m_61143_((Property)f_54117_));
            pLevel.m_46586_(neighborPos, (Block)this, neighborPos);
            this.updateNeighbours(newState, pLevel, pHit.m_82425_());
        }
        super.m_5581_(pLevel, pState, pHit, pProjectile);
    }
}

