/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.block.custom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.mezimaru.mastersword.block.custom.CustomCampfireBlock;
import net.mezimaru.mastersword.item.ModItems;
import net.mezimaru.mastersword.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class NayruCampfireBlock
extends CustomCampfireBlock {
    private final List<MutableComponent> riddles = new ArrayList<MutableComponent>();
    private final List<ItemStack> solutions = new ArrayList<ItemStack>();
    private final Random random = new Random();
    private int currentRiddleIndex = -1;
    private int currentSolutionIndex = -1;

    public NayruCampfireBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.initializeRiddles();
    }

    private boolean hasInteractedWithCampfire(Player player, BlockPos pos) {
        return player.getPersistentData().m_128441_("interacted_with_nayru_campfire_" + pos.toString());
    }

    private void markCampfireAsInteracted(Player player, BlockPos pos) {
        player.getPersistentData().m_128379_("interacted_with_nayru_campfire_" + pos.toString(), true);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(hand);
        if (!level.f_46443_) {
            if (this.riddles.isEmpty()) {
                this.resetRiddlesAndSolutions();
                player.m_213846_((Component)Component.m_237115_((String)"message.mastersword.nayru_reset_riddles"));
                return InteractionResult.FAIL;
            }
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                ItemStack stack = player.m_150109_().m_8020_(i);
                if (stack.m_41619_() || stack.m_41720_() != ModItems.NAYRUFLAME.get()) continue;
                player.m_213846_((Component)Component.m_237115_((String)"message.mastersword.already_have_nayru_inventory"));
                return InteractionResult.FAIL;
            }
            if (this.hasInteractedWithCampfire(player, pos)) {
                player.m_213846_((Component)Component.m_237115_((String)"message.mastersword.already_received_nayru_here"));
                return InteractionResult.FAIL;
            }
            if (heldItem.m_41619_()) {
                if (this.currentRiddleIndex == -1) {
                    this.currentSolutionIndex = this.currentRiddleIndex = this.random.nextInt(this.riddles.size());
                }
                MutableComponent currentRiddle = this.riddles.get(this.currentRiddleIndex);
                player.m_213846_((Component)currentRiddle);
            } else {
                if (this.currentSolutionIndex >= 0 && this.currentSolutionIndex < this.solutions.size() && ItemStack.m_41656_((ItemStack)heldItem, (ItemStack)this.solutions.get(this.currentSolutionIndex))) {
                    player.m_213846_((Component)Component.m_237115_((String)"message.mastersword.give_nayru_blessing"));
                    level.m_6269_(null, (Entity)player, (SoundEvent)ModSounds.SUCCESS.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                    heldItem.m_41774_(1);
                    level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, new ItemStack((ItemLike)ModItems.NAYRUFLAME.get())));
                    this.markCampfireAsInteracted(player, pos);
                    this.riddles.remove(this.currentRiddleIndex);
                    this.solutions.remove(this.currentSolutionIndex);
                    this.currentRiddleIndex = -1;
                    this.currentSolutionIndex = -1;
                    return InteractionResult.SUCCESS;
                }
                String heldItemName = heldItem.m_41611_().getString();
                player.m_213846_((Component)Component.m_237115_((String)(heldItemName + " message.mastersword.nayru_incorrect_riddle")));
                return InteractionResult.FAIL;
            }
        }
        return InteractionResult.SUCCESS;
    }

    private void resetRiddlesAndSolutions() {
        this.riddles.clear();
        this.solutions.clear();
        this.currentRiddleIndex = -1;
        this.currentSolutionIndex = -1;
        this.initializeRiddles();
    }

    private void initializeRiddles() {
        long seed = System.nanoTime();
        Collections.shuffle(this.riddles, new Random(seed));
        Collections.shuffle(this.solutions, new Random(seed));
        this.riddles.add(Component.m_237115_((String)"riddle.mastersword.feather"));
        this.currentSolutionIndex = 0;
        this.riddles.add(Component.m_237115_((String)"riddle.mastersword.torch"));
        this.currentSolutionIndex = 1;
        this.riddles.add(Component.m_237115_((String)"riddle.mastersword.book"));
        this.currentSolutionIndex = 2;
        this.riddles.add(Component.m_237115_((String)"riddle.mastersword.water_bucket"));
        this.currentSolutionIndex = 3;
        this.riddles.add(Component.m_237115_((String)"riddle.mastersword.spider_eye"));
        this.currentSolutionIndex = 4;
        this.riddles.add(Component.m_237115_((String)"riddle.mastersword.rose_bush"));
        this.currentSolutionIndex = 5;
        this.riddles.add(Component.m_237115_((String)"riddle.mastersword.flint_and_steel"));
        this.currentSolutionIndex = 6;
        this.riddles.add(Component.m_237115_((String)"riddle.mastersword.ender_pearl"));
        this.currentSolutionIndex = 7;
        this.riddles.add(Component.m_237115_((String)"riddle.mastersword.leather"));
        this.currentSolutionIndex = 8;
        this.riddles.add(Component.m_237115_((String)"riddle.mastersword.carrot"));
        this.currentSolutionIndex = 9;
        this.riddles.add(Component.m_237115_((String)"riddle.mastersword.iron_ingot"));
        this.currentSolutionIndex = 10;
        this.solutions.add(new ItemStack((ItemLike)Items.f_42402_));
        this.solutions.add(new ItemStack((ItemLike)Items.f_42000_));
        this.solutions.add(new ItemStack((ItemLike)Items.f_42517_));
        this.solutions.add(new ItemStack((ItemLike)Items.f_42447_));
        this.solutions.add(new ItemStack((ItemLike)Items.f_42591_));
        this.solutions.add(new ItemStack((ItemLike)Items.f_42208_));
        this.solutions.add(new ItemStack((ItemLike)Items.f_42409_));
        this.solutions.add(new ItemStack((ItemLike)Items.f_42584_));
        this.solutions.add(new ItemStack((ItemLike)Items.f_42454_));
        this.solutions.add(new ItemStack((ItemLike)Items.f_42619_));
        this.solutions.add(new ItemStack((ItemLike)Items.f_42416_));
    }
}

