/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.mezimaru.mastersword.client.MagicMeterData;
import net.mezimaru.mastersword.config.MasterSwordCommonConfigs;
import net.mezimaru.mastersword.util.ColorAndAlphaInterpolator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class MagicMeterOverlay {
    private static final ColorAndAlphaInterpolator colorInterpolator = new ColorAndAlphaInterpolator(-16711844, -1, 0.0f, 1.0f, 5.0f);
    private static final ResourceLocation FILLED_MAGIC = new ResourceLocation("mastersword", "textures/gui/magic_full.png");
    private static final ResourceLocation FILLED_MAGIC_HALF_COST = new ResourceLocation("mastersword", "textures/gui/magic_full_half_cost.png");
    private static final ResourceLocation FILLED_MAGIC_SECOND = new ResourceLocation("mastersword", "textures/gui/magic_full_second.png");
    private static final ResourceLocation FILLED_MAGIC_SECOND_HALF_COST = new ResourceLocation("mastersword", "textures/gui/magic_full_second_half_cost.png");
    private static final ResourceLocation EMPTY_MAGIC = new ResourceLocation("mastersword", "textures/gui/magic_empty.png");
    private static final ResourceLocation EMPTY_MAGIC_HALF_COST = new ResourceLocation("mastersword", "textures/gui/magic_empty_half_cost.png");
    private static float displayedMana = 0.0f;
    private static boolean transitionMinMax = false;
    private static float currentAlpha = 1.0f;
    private static float globalAlpha = 1.0f;
    public static final IGuiOverlay MAGIC_METER = (gui, guiGraphics, partialTick, screenWidth, screenHeight) -> {
        Minecraft client = Minecraft.m_91087_();
        PoseStack matrices = guiGraphics.m_280168_();
        if (client.f_91074_ == null || client.f_91074_.m_7500_() || client.f_91074_.m_5833_()) {
            return;
        }
        int currentMagic = MagicMeterData.getMagicAmount((Player)client.f_91074_);
        int maxMagic = MagicMeterData.getMaxMagic((Player)client.f_91074_);
        int whenNeededRenderTime = MagicMeterData.getWhenNeededRenderTimer((Player)client.f_91074_);
        globalAlpha = !((Boolean)MasterSwordCommonConfigs.ALWAYS_SHOW_MAGIC_METER.get()).booleanValue() && whenNeededRenderTime <= 0 ? (globalAlpha > 0.01f ? Mth.m_14179_((float)(partialTick * 0.1f), (float)globalAlpha, (float)0.0f) : 0.0f) : (globalAlpha < 0.91f ? Mth.m_14179_((float)(partialTick * 0.1f), (float)globalAlpha, (float)1.0f) : 1.0f);
        if (globalAlpha > 0.1f) {
            matrices.m_85836_();
            int width = client.m_91268_().m_85445_();
            int height = client.m_91268_().m_85446_();
            int mana_x = width / 2 - 320 + (Integer)MasterSwordCommonConfigs.MAGIC_METER_POSITION_X.get();
            int mana_y = height - 42 - (Integer)MasterSwordCommonConfigs.MAGIC_METER_POSITION_Y.get();
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)globalAlpha);
            if (MagicMeterData.getMaxMagic((Player)client.f_91074_) == 200) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)EMPTY_MAGIC_HALF_COST);
                guiGraphics.m_280163_(EMPTY_MAGIC_HALF_COST, mana_x, mana_y, 0.0f, 0.0f, 16, 42, 16, 42);
            } else {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)EMPTY_MAGIC);
                guiGraphics.m_280163_(EMPTY_MAGIC, mana_x, mana_y, 0.0f, 0.0f, 16, 42, 16, 42);
            }
            displayedMana = Mth.m_14179_((float)(partialTick * 0.25f), (float)displayedMana, (float)currentMagic);
            if (displayedMana > (float)maxMagic) {
                displayedMana = maxMagic;
            }
            int filledHeight = (int)(displayedMana / (float)maxMagic * 33.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            currentAlpha = colorInterpolator.updateAndGetAlpha(partialTick);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(globalAlpha * currentAlpha));
            if (MagicMeterData.getMaxMagic((Player)client.f_91074_) == 200) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)FILLED_MAGIC_HALF_COST);
                guiGraphics.m_280163_(FILLED_MAGIC_HALF_COST, mana_x + 4, mana_y + 4 + (33 - filledHeight), 0.0f, (float)(33 - filledHeight), 8, filledHeight, 8, 33);
            } else {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)FILLED_MAGIC);
                guiGraphics.m_280163_(FILLED_MAGIC, mana_x + 4, mana_y + 4 + (33 - filledHeight), 0.0f, (float)(33 - filledHeight), 8, filledHeight, 8, 33);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(globalAlpha * (1.0f - currentAlpha)));
            if (MagicMeterData.getMaxMagic((Player)client.f_91074_) == 200) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)FILLED_MAGIC_SECOND_HALF_COST);
                guiGraphics.m_280163_(FILLED_MAGIC_SECOND_HALF_COST, mana_x + 4, mana_y + 4 + (33 - filledHeight), 0.0f, (float)(33 - filledHeight), 8, filledHeight, 8, 33);
            } else {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)FILLED_MAGIC_SECOND);
                guiGraphics.m_280163_(FILLED_MAGIC_SECOND, mana_x + 4, mana_y + 4 + (33 - filledHeight), 0.0f, (float)(33 - filledHeight), 8, filledHeight, 8, 33);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            matrices.m_85836_();
            if (currentMagic == maxMagic && !transitionMinMax) {
                colorInterpolator.resetTransition(colorInterpolator.updateAndGetColor(partialTick, globalAlpha), -16711844, currentAlpha, 0.0f, 40.0f);
                transitionMinMax = true;
            } else if (currentMagic != maxMagic && transitionMinMax) {
                colorInterpolator.resetTransition(colorInterpolator.updateAndGetColor(partialTick, globalAlpha), -1, currentAlpha, 1.0f, 40.0f);
                transitionMinMax = false;
            }
            matrices.m_85849_();
            matrices.m_85849_();
        }
    };
}

