/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.entity.custom;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import net.mezimaru.mastersword.item.ModItems;
import net.mezimaru.mastersword.item.custom.HylianBottleEmptyItem;
import net.mezimaru.mastersword.particle.custom.ColoredParticleType;
import net.mezimaru.mastersword.sound.ModSounds;
import net.mezimaru.mastersword.util.ParticleHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BasePetFairyEntity
extends TamableAnimal
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int collectXpTickCounter = 0;

    public BasePetFairyEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.m_7105_(true);
    }

    public static AttributeSupplier setAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22283_, 3.0).m_22268_(Attributes.f_22279_, (double)0.1f).m_22268_(Attributes.f_22280_, (double)0.1f).m_22265_();
    }

    public static boolean canFairySpawn(EntityType<? extends BasePetFairyEntity> entityType, LevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        return pRandom.m_188503_(20) == 0;
    }

    public boolean m_6779_(LivingEntity pTarget) {
        if (pTarget.equals((Object)this.m_269323_())) {
            return false;
        }
        return super.m_6779_(pTarget);
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    protected boolean m_7341_(Entity pVehicle) {
        return false;
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return false;
    }

    protected float m_6431_(Pose pPose, EntityDimensions pSize) {
        return pSize.f_20378_ - 1.35f;
    }

    public boolean m_6072_() {
        return false;
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_271807_() {
        return false;
    }

    public boolean m_20039_(BlockPos pPos, BlockState pState) {
        return false;
    }

    protected AABB m_142242_() {
        float size = 0.5f;
        return new AABB(this.m_20185_() - (double)(size / 2.0f), this.m_20186_() + 0.2, this.m_20189_() - (double)(size / 2.0f), this.m_20185_() + (double)(size / 2.0f), this.m_20186_() + (double)size, this.m_20189_() + (double)(size / 2.0f));
    }

    public boolean m_7337_(Entity pEntity) {
        return false;
    }

    protected PathNavigation m_6037_(Level pLevel) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, pLevel);
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(true);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.m_6109_()) {
            if (this.m_20069_()) {
                this.m_19920_(0.02f, pTravelVector);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)0.8f));
            } else if (this.m_20077_()) {
                this.m_19920_(0.02f, pTravelVector);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_(0.5));
            } else {
                this.m_19920_(this.m_6113_(), pTravelVector);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)0.91f));
            }
        }
        this.m_267651_(false);
    }

    protected void m_7840_(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
    }

    public boolean m_142066_() {
        return false;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (pSource.m_19390_() || pSource == this.m_269291_().m_287172_()) {
            return super.m_6469_(pSource, pAmount);
        }
        return false;
    }

    public int m_213860_() {
        return 0;
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(1, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.5, 5.0f, 1.0f, true));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 0.8));
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(Entity p_20971_) {
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.fairy.idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        SoundEvent[] ambientSounds = new SoundEvent[]{(SoundEvent)ModSounds.FAIRY1.get(), (SoundEvent)ModSounds.FAIRY1.get(), SoundEvents.f_271165_};
        int randomIndex = this.m_217043_().m_188503_(ambientSounds.length);
        return ambientSounds[randomIndex];
    }

    public int m_8100_() {
        return super.m_8100_() + 300;
    }

    protected float m_6121_() {
        return 0.4f;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void m_8107_() {
        if (this.f_19796_.m_188503_(100) < 2) {
            double x = this.m_20185_() + this.f_19796_.m_188583_() * 0.1;
            double y = this.m_20186_() + 0.3 + this.f_19796_.m_188583_() * 0.1;
            double z = this.m_20189_() + this.f_19796_.m_188583_() * 0.1;
            float[] fairyColor = this.getFairyColor(this.m_6095_().toString());
            ColoredParticleType.ColoredParticleData particleData = new ColoredParticleType.ColoredParticleData(fairyColor[0], fairyColor[1], fairyColor[2]);
            ParticleHelper.spawnParticle(this.f_19853_, particleData, x, y, z, 0.0, 0.0, 0.0);
        }
        super.m_8107_();
    }

    private float[] getFairyColor(String fairyType) {
        switch (fairyType) {
            case "entity.mastersword.navi": {
                return new float[]{0.678f, 0.847f, 0.902f};
            }
            case "entity.mastersword.tatl": {
                return new float[]{1.0f, 1.0f, 0.0f};
            }
            case "entity.mastersword.tael": {
                return new float[]{0.278f, 0.082f, 0.404f};
            }
            case "entity.mastersword.ciela": {
                return new float[]{0.827f, 0.827f, 0.827f};
            }
            case "entity.mastersword.leaf": {
                return new float[]{0.949f, 0.318f, 0.424f};
            }
            case "entity.mastersword.neri": {
                return new float[]{0.1804f, 0.4902f, 1.0f};
            }
            case "entity.mastersword.white_fairy": {
                return new float[]{1.0f, 1.0f, 1.0f};
            }
            case "entity.mastersword.gray_fairy": {
                return new float[]{0.5f, 0.5f, 0.5f};
            }
            case "entity.mastersword.black_fairy": {
                return new float[]{0.165f, 0.165f, 0.165f};
            }
            case "entity.mastersword.orange_fairy": {
                return new float[]{0.878f, 0.49f, 0.086f};
            }
            case "entity.mastersword.lime_fairy": {
                return new float[]{0.38f, 0.752f, 0.0f};
            }
            case "entity.mastersword.green_fairy": {
                return new float[]{0.506f, 0.612f, 0.0f};
            }
            case "entity.mastersword.cyan_fairy": {
                return new float[]{0.0f, 1.0f, 1.0f};
            }
            case "entity.mastersword.purple_fairy": {
                return new float[]{0.627f, 0.459f, 1.0f};
            }
            case "entity.mastersword.magenta_fairy": {
                return new float[]{0.989f, 0.376f, 0.894f};
            }
            case "entity.mastersword.brown_fairy": {
                return new float[]{0.675f, 0.522f, 0.361f};
            }
            case "entity.mastersword.golden_fairy": {
                return new float[]{0.765f, 0.62f, 0.243f};
            }
        }
        return new float[]{0.0f, 1.0f, 1.0f};
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack heldItem = player.m_21120_(hand);
        if (heldItem.m_41720_() instanceof HylianBottleEmptyItem) {
            if (this.m_21805_() != null && !player.m_20148_().equals(this.m_21805_())) {
                player.m_5661_((Component)Component.m_237115_((String)"message.mastersword.not_your_fairy"), true);
                return InteractionResult.FAIL;
            }
            String fairyType = this.m_6095_().toString();
            Item fairyBottleItem = null;
            switch (fairyType) {
                case "entity.mastersword.navi": {
                    fairyBottleItem = (Item)ModItems.HYLIAN_BOTTLE_NAVI.get();
                    break;
                }
                case "entity.mastersword.tatl": {
                    fairyBottleItem = (Item)ModItems.HYLIAN_BOTTLE_TATL.get();
                    break;
                }
                case "entity.mastersword.tael": {
                    fairyBottleItem = (Item)ModItems.HYLIAN_BOTTLE_TAEL.get();
                    break;
                }
                case "entity.mastersword.ciela": {
                    fairyBottleItem = (Item)ModItems.HYLIAN_BOTTLE_CIELA.get();
                    break;
                }
                case "entity.mastersword.leaf": {
                    fairyBottleItem = (Item)ModItems.HYLIAN_BOTTLE_LEAF.get();
                    break;
                }
                case "entity.mastersword.neri": {
                    fairyBottleItem = (Item)ModItems.HYLIAN_BOTTLE_NERI.get();
                    break;
                }
                case "entity.mastersword.white_fairy": {
                    fairyBottleItem = (Item)ModItems.HYLIAN_BOTTLE_WHITE_FAIRY.get();
                    break;
                }
                case "entity.mastersword.gray_fairy": {
                    fairyBottleItem = (Item)ModItems.HYLIAN_BOTTLE_GRAY_FAIRY.get();
                    break;
                }
                case "entity.mastersword.black_fairy": {
                    fairyBottleItem = (Item)ModItems.HYLIAN_BOTTLE_BLACK_FAIRY.get();
                    break;
                }
                case "entity.mastersword.orange_fairy": {
                    fairyBottleItem = (Item)ModItems.HYLIAN_BOTTLE_ORANGE_FAIRY.get();
                    break;
                }
                case "entity.mastersword.lime_fairy": {
                    fairyBottleItem = (Item)ModItems.HYLIAN_BOTTLE_LIME_FAIRY.get();
                    break;
                }
                case "entity.mastersword.green_fairy": {
                    fairyBottleItem = (Item)ModItems.HYLIAN_BOTTLE_GREEN_FAIRY.get();
                    break;
                }
                case "entity.mastersword.cyan_fairy": {
                    fairyBottleItem = (Item)ModItems.HYLIAN_BOTTLE_CYAN_FAIRY.get();
                    break;
                }
                case "entity.mastersword.purple_fairy": {
                    fairyBottleItem = (Item)ModItems.HYLIAN_BOTTLE_PURPLE_FAIRY.get();
                    break;
                }
                case "entity.mastersword.magenta_fairy": {
                    fairyBottleItem = (Item)ModItems.HYLIAN_BOTTLE_MAGENTA_FAIRY.get();
                    break;
                }
                case "entity.mastersword.brown_fairy": {
                    fairyBottleItem = (Item)ModItems.HYLIAN_BOTTLE_BROWN_FAIRY.get();
                    break;
                }
                case "entity.mastersword.golden_fairy": {
                    fairyBottleItem = (Item)ModItems.HYLIAN_BOTTLE_GOLDEN_FAIRY.get();
                    break;
                }
                default: {
                    fairyBottleItem = (Item)ModItems.HYLIAN_BOTTLE_CYAN_FAIRY.get();
                }
            }
            if (fairyBottleItem != null) {
                CompoundTag tag;
                int soundNum = new Random().nextInt(3) + 1;
                switch (soundNum) {
                    case 1: {
                        this.f_19853_.m_6269_(null, (Entity)player, (SoundEvent)ModSounds.BOTTLE1.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                        break;
                    }
                    case 2: {
                        this.f_19853_.m_6269_(null, (Entity)player, (SoundEvent)ModSounds.BOTTLE2.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                        break;
                    }
                    default: {
                        this.f_19853_.m_6269_(null, (Entity)player, (SoundEvent)ModSounds.BOTTLE3.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                    }
                }
                player.m_5810_();
                if (!player.m_7500_()) {
                    heldItem.m_41774_(1);
                }
                if (!(tag = player.getPersistentData()).m_128441_("PlayerPersisted")) {
                    tag.m_128365_("PlayerPersisted", (Tag)new CompoundTag());
                }
                CompoundTag persistTag = tag.m_128469_("PlayerPersisted");
                ItemStack fairyBottleItemStack = new ItemStack((ItemLike)fairyBottleItem, 1);
                if (!player.m_36356_(fairyBottleItemStack)) {
                    this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, player.m_20185_(), player.m_20186_(), player.m_20189_(), fairyBottleItemStack));
                }
                if (player.m_20148_().equals(this.m_21805_())) {
                    persistTag.m_128379_("hasPetFairy", false);
                }
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6071_(player, hand);
    }

    public void m_8119_() {
        LivingEntity owner;
        Player player;
        super.m_8119_();
        if (this.m_20159_()) {
            this.m_8127_();
        }
        if ((player = (Player)(owner = this.m_269323_())) != null) {
            if (this.m_20280_((Entity)player) > 250.0 && this.m_20280_((Entity)player) < 350.0) {
                this.m_21573_().m_5624_((Entity)player, 1.5);
            } else if (this.m_20280_((Entity)player) > 300.0) {
                BlockPos blockpos = player.m_20183_();
                int j = this.f_19796_.m_216332_(-3, 3);
                int k = this.f_19796_.m_216332_(-1, 1);
                int l = this.f_19796_.m_216332_(-3, 3);
                this.m_6021_(blockpos.m_123341_() + j, blockpos.m_123342_() + k, blockpos.m_123343_() + l);
            }
        }
        ++this.collectXpTickCounter;
        if (this.collectXpTickCounter > 200 && player != null && player.m_6084_()) {
            List xpOrbs = this.f_19853_.m_6443_(ExperienceOrb.class, this.m_20191_().m_82400_(20.0), entity -> true);
            if (!xpOrbs.isEmpty()) {
                Optional<ExperienceOrb> closestOrbOptional = xpOrbs.stream().min(Comparator.comparingDouble(arg_0 -> ((BasePetFairyEntity)this).m_20280_(arg_0)));
                closestOrbOptional.ifPresent(closestOrb -> {
                    this.m_21573_().m_5624_((Entity)closestOrb, 1.4);
                    if (this.m_20280_((Entity)closestOrb) < 2.0) {
                        closestOrb.m_20329_((Entity)this);
                        this.m_21573_().m_5624_((Entity)player, 1.2);
                        if (this.m_20280_((Entity)player) < 2.0 && !this.m_9236_().f_46443_) {
                            this.m_20197_().forEach(riding -> {
                                if (riding instanceof ExperienceOrb) {
                                    riding.m_6123_(player);
                                }
                            });
                        }
                    }
                });
            } else {
                this.collectXpTickCounter = 0;
            }
        }
    }

    public void m_6123_(@NotNull Player pEntity) {
        if (this.m_269323_() == pEntity || this.m_269323_() == null) {
            super.m_6123_(pEntity);
        }
    }

    protected boolean m_7310_(@Nonnull Entity passenger) {
        return super.m_7310_(passenger) || passenger instanceof ExperienceOrb;
    }

    public double m_6048_() {
        return 0.0;
    }

    public boolean m_5545_(LevelAccessor pLevel, MobSpawnType pSpawnReason) {
        return true;
    }

    public int m_5792_() {
        return 1;
    }
}

