/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.entity.custom;

import java.util.Comparator;
import java.util.List;
import net.mezimaru.mastersword.sound.ModSounds;
import net.mezimaru.mastersword.util.FriendlyFireHelper;
import net.mezimaru.mastersword.util.ParticleHelper;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BombchuEntity
extends TamableAnimal
implements GeoEntity {
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(BombchuEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final float explosionRadius = 1.5f;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final double bombchuSpeed = 0.35;
    private int climbingAnimationTicks = 0;
    private LivingEntity target;
    private int explosionTimer = 80;
    private int soundTimer = 0;

    public BombchuEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_6858_(true);
    }

    public static AttributeSupplier setAttributes() {
        return TamableAnimal.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, (double)0.1f).m_22265_();
    }

    public boolean m_20068_() {
        return this.m_20069_();
    }

    protected AABB m_142242_() {
        float size = 0.5f;
        return new AABB(this.m_20185_() - (double)size, this.m_20186_(), this.m_20189_(), this.m_20185_() + (double)size, this.m_20186_() + (double)size, this.m_20189_() + (double)size);
    }

    protected PathNavigation m_6037_(Level pLevel) {
        return new WallClimberNavigation((Mob)this, pLevel);
    }

    public boolean m_203441_(FluidState pFluidState) {
        return true;
    }

    protected boolean m_6129_() {
        return false;
    }

    protected float m_6431_(Pose pPose, EntityDimensions pSize) {
        return pSize.f_20378_ - 1.35f;
    }

    public boolean m_6072_() {
        return false;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    public boolean m_20147_() {
        return true;
    }

    public boolean m_142066_() {
        return false;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        return false;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.f_19853_.m_5594_(null, this.m_20097_(), (SoundEvent)ModSounds.BOMBCHU_START.get(), SoundSource.PLAYERS, 0.7f, 1.0f);
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.soundTimer;
        if (this.soundTimer % 5 == 0) {
            this.f_19853_.m_5594_(null, this.m_20097_(), (SoundEvent)ModSounds.BOMBCHU_LOOP.get(), SoundSource.PLAYERS, 0.7f, 1.0f);
        }
        if (!this.m_9236_().f_46443_) {
            this.setClimbing(this.f_19862_);
            if (this.isClimbing()) {
                this.m_20334_(this.m_20184_().f_82479_, 0.35, this.m_20184_().f_82481_);
            }
        }
        if (this.isClimbing()) {
            this.m_20242_(true);
            ++this.climbingAnimationTicks;
        } else {
            this.m_20242_(false);
            this.climbingAnimationTicks = 0;
        }
        if (this.target == null) {
            this.moveForward();
        } else {
            this.navigateToTarget();
        }
        this.updateRotation();
        List livingEntities = this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82400_(20.0), entity -> !(entity instanceof BombchuEntity));
        this.target = livingEntities.stream().filter(entity -> FriendlyFireHelper.checkFriendlyFire(entity, (Player)this.m_269323_())).min(Comparator.comparingDouble(arg_0 -> ((BombchuEntity)this).m_20280_(arg_0))).orElse(null);
        if (this.m_20069_()) {
            Vec3 pos = this.m_20182_();
            Vec3 deltaMovement = this.m_20184_();
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, pos.f_82479_ - deltaMovement.f_82479_ * 0.25, pos.f_82480_ - deltaMovement.f_82480_ * 0.25, pos.f_82481_ - deltaMovement.f_82481_ * 0.25, deltaMovement.f_82479_, deltaMovement.f_82480_, deltaMovement.f_82481_);
            this.m_20256_(deltaMovement.m_82490_(0.2));
        }
        if (!this.m_20069_() && this.f_19796_.m_188503_(100) < 30) {
            double x = this.m_20185_() + this.f_19796_.m_188583_() * 0.1;
            double y = this.m_20186_() + 0.1 + this.f_19796_.m_188583_() * 0.1;
            double z = this.m_20189_() + this.f_19796_.m_188583_() * 0.1;
            ParticleHelper.spawnParticle(this.f_19853_, (ParticleOptions)DustParticleOptions.f_123656_, x, y, z, 0.0, 0.0, 0.0);
        }
        if (this.target != null && this.m_20280_((Entity)this.target) < 1.0) {
            this.explode();
        }
        --this.explosionTimer;
        if (this.explosionTimer <= 0) {
            this.explode();
        }
    }

    private void moveForward() {
        Vec3 forwardMovement = this.m_20156_().m_82490_(0.35);
        this.m_20334_(forwardMovement.f_82479_, this.m_20184_().f_82480_, forwardMovement.f_82481_);
    }

    private void navigateToTarget() {
        if (this.target != null) {
            Vec3 targetDirection = new Vec3(this.target.m_20185_() - this.m_20185_(), this.target.m_20186_() - this.m_20186_(), this.target.m_20189_() - this.m_20189_());
            double horizontalDistance = Math.sqrt(targetDirection.f_82479_ * targetDirection.f_82479_ + targetDirection.f_82481_ * targetDirection.f_82481_);
            Vec3 horizontalMovement = new Vec3(targetDirection.f_82479_ / horizontalDistance, 0.0, targetDirection.f_82481_ / horizontalDistance).m_82490_(0.35);
            this.m_20334_(horizontalMovement.f_82479_, this.m_20184_().f_82480_, horizontalMovement.f_82481_);
        }
    }

    private void explode() {
        this.f_19853_.m_255391_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.5f, false, Level.ExplosionInteraction.MOB);
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    private void updateRotation() {
        Vec3 movement = this.m_20184_();
        if (movement.m_82556_() > 0.0) {
            float yaw = (float)(Math.atan2(movement.f_82479_, movement.f_82481_) * 57.29577951308232);
            this.m_146922_(-yaw);
        }
    }

    public void m_146922_(float pYRot) {
        super.m_146922_(pYRot);
        this.f_20885_ = pYRot;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    public boolean isClimbing() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean pClimbing) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        b0 = pClimbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)b0);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        if (this.isClimbing() && this.climbingAnimationTicks >= 5) {
            tAnimationState.getController().setAnimation(RawAnimation.begin().then("climb_up", Animation.LoopType.LOOP));
        } else {
            tAnimationState.getController().setAnimation(RawAnimation.begin().then("travel", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

