/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.entity.custom;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.mezimaru.mastersword.item.ModItems;
import net.mezimaru.mastersword.network.ModMessages;
import net.mezimaru.mastersword.network.packet.StopBoomerangSoundS2CPacket;
import net.mezimaru.mastersword.sound.ModSounds;
import net.mezimaru.mastersword.util.FriendlyFireHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class BoomerangProjectileEntity
extends Projectile {
    private static final double BASE_DAMAGE = 2.0;
    private static final EntityDataAccessor<ItemStack> STACK = SynchedEntityData.m_135353_(BoomerangProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Boolean> RETURNING = SynchedEntityData.m_135353_(BoomerangProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final String TAG_RETURNING = "returning";
    private static final String TAG_LIVE_TIME = "liveTime";
    private static final String TAG_BLOCKS_BROKEN = "hitCount";
    private static final String TAG_RETURN_SLOT = "returnSlot";
    private static final String TAG_ITEM_STACK = "itemStack";
    protected int liveTime;
    protected LivingEntity owner;
    private int slot;
    private int blockHitCount;
    private IntOpenHashSet entitiesHit;
    private UUID ownerId;

    public BoomerangProjectileEntity(EntityType<? extends Projectile> type, Level level, LivingEntity livingEntity) {
        super(type, level);
        Vec3 pos = livingEntity.m_20182_();
        this.m_6034_(pos.f_82479_, pos.f_82480_ + (double)livingEntity.m_20192_(), pos.f_82481_);
        this.ownerId = livingEntity.m_20148_();
    }

    public BoomerangProjectileEntity(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.f_19853_.m_6269_(null, (Entity)this, (SoundEvent)ModSounds.BOOMERANG.get(), SoundSource.NEUTRAL, 1.0f, 0.8f + this.f_19853_.f_46441_.m_188501_() * 0.2f);
    }

    public void m_6686_(double x, double y, double z, float velocity, float inaccuracy) {
        Vec3 vec = new Vec3(x, y, z).m_82541_().m_82520_(this.f_19796_.m_188583_() * (double)0.0075f * (double)inaccuracy, this.f_19796_.m_188583_() * (double)0.0075f * (double)inaccuracy, this.f_19796_.m_188583_() * (double)0.0075f * (double)inaccuracy).m_82490_((double)velocity);
        this.m_20256_(vec);
        float f = (float)vec.m_165924_();
        this.m_146922_((float)(Mth.m_14136_((double)vec.f_82479_, (double)vec.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)vec.f_82480_, (double)f) * 57.2957763671875));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    protected void m_5790_(EntityHitResult pResult) {
        super.m_5790_(pResult);
        Entity entity = pResult.m_82443_();
        LivingEntity thrower = this.getThrower();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            boolean shouldDamage = true;
            if (thrower instanceof Player) {
                Player player = (Player)thrower;
                shouldDamage = FriendlyFireHelper.checkFriendlyFire(livingEntity, player);
            }
            if (shouldDamage) {
                livingEntity.m_6469_(this.m_269291_().m_269390_((Entity)thrower, (Entity)this), 2.0f);
                double knockback = 0.5;
                double knockbackResistance = Math.max(0.0, 1.0 - livingEntity.m_21133_(Attributes.f_22278_));
                Vec3 vec3 = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_(knockback * 0.6 * knockbackResistance);
                if (vec3.m_82556_() > 0.0) {
                    livingEntity.m_5997_(vec3.f_82479_, 0.2, vec3.f_82481_);
                }
            }
            this.setReturning();
        }
    }

    public void m_6001_(double x, double y, double z) {
        this.m_20334_(x, y, z);
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            float f = (float)Math.sqrt(x * x + z * z);
            this.m_146922_((float)(Mth.m_14136_((double)x, (double)z) * 57.2957763671875));
            this.m_146926_((float)(Mth.m_14136_((double)y, (double)f) * 57.2957763671875));
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(STACK, (Object)new ItemStack((ItemLike)ModItems.BOOMERANG.get()));
        this.f_19804_.m_135372_(RETURNING, (Object)false);
    }

    protected void checkImpact() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        Vec3 motion = this.m_20184_();
        Vec3 position = this.m_20182_();
        Vec3 rayEnd = position.m_82549_(motion);
        boolean doEntities = true;
        while (this.m_6084_() && !this.isReturning()) {
            EntityHitResult result;
            if (doEntities) {
                result = this.raycastEntities(position, rayEnd);
                if (result != null) {
                    this.m_6532_((HitResult)result);
                    continue;
                }
                doEntities = false;
                continue;
            }
            result = this.m_9236_().m_45547_(new ClipContext(position, rayEnd, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (result.m_6662_() == HitResult.Type.MISS) {
                return;
            }
            this.m_6532_((HitResult)result);
        }
    }

    @Nullable
    protected EntityHitResult raycastEntities(Vec3 from, Vec3 to) {
        return ProjectileUtil.m_37304_((Level)this.m_9236_(), (Entity)this, (Vec3)from, (Vec3)to, (AABB)this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0), entity -> !(entity.m_5833_() || !entity.m_6084_() || !entity.m_6087_() && !(entity instanceof BoomerangProjectileEntity) || entity == this.getThrower() || this.entitiesHit != null && this.entitiesHit.contains(entity.m_19879_())));
    }

    protected void m_6532_(@Nonnull HitResult result) {
        super.m_6532_(result);
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            this.clank();
        }
    }

    public void clank() {
        this.setReturning();
    }

    protected void setReturning() {
        this.f_19804_.m_135381_(RETURNING, (Object)true);
    }

    @Nullable
    public LivingEntity getThrower() {
        if (this.owner == null && this.ownerId != null && this.m_9236_() instanceof ServerLevel) {
            Entity entity = ((ServerLevel)this.m_9236_()).m_8791_(this.ownerId);
            if (entity instanceof LivingEntity) {
                this.owner = (LivingEntity)entity;
            } else {
                this.ownerId = null;
            }
        }
        return this.owner;
    }

    public ItemStack getStack() {
        return (ItemStack)this.f_19804_.m_135370_(STACK);
    }

    public void setStack(ItemStack stack) {
        this.f_19804_.m_135381_(STACK, (Object)stack);
    }

    protected boolean m_7310_(@Nonnull Entity passenger) {
        return super.m_7310_(passenger) || passenger instanceof ItemEntity || passenger instanceof ExperienceOrb;
    }

    public double m_6048_() {
        return 0.0;
    }

    public boolean isReturning() {
        return (Boolean)this.f_19804_.m_135370_(RETURNING);
    }

    public void setThrowData(int slot, ItemStack stack) {
        this.slot = slot;
        this.setStack(stack.m_41777_());
    }

    private void giveItemToPlayer(Player player, ItemEntity itemEntity) {
        itemEntity.m_32010_(0);
        itemEntity.m_6123_(player);
        if (itemEntity.m_6084_()) {
            ItemStack drop = itemEntity.m_32055_();
            player.m_36176_(drop, false);
            itemEntity.m_146870_();
        }
    }

    public boolean hasDrag() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6783_(double distance) {
        double d0 = this.m_20191_().m_82309_() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    public void m_8119_() {
        float drag;
        Vec3 pos = this.m_20182_();
        this.f_19790_ = pos.f_82479_;
        this.f_19791_ = pos.f_82480_;
        this.f_19792_ = pos.f_82481_;
        super.m_8119_();
        if (!this.isReturning()) {
            this.checkImpact();
        }
        Vec3 ourMotion = this.m_20184_();
        this.m_6034_(pos.f_82479_ + ourMotion.f_82479_, pos.f_82480_ + ourMotion.f_82480_, pos.f_82481_ + ourMotion.f_82481_);
        float f = (float)ourMotion.m_165924_();
        this.m_146922_((float)(Mth.m_14136_((double)ourMotion.f_82479_, (double)ourMotion.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)ourMotion.f_82480_, (double)f) * 57.2957763671875));
        while (this.m_146909_() - this.f_19860_ < -180.0f) {
            this.f_19860_ -= 360.0f;
        }
        while (this.m_146909_() - this.f_19860_ >= 180.0f) {
            this.f_19860_ += 360.0f;
        }
        while (this.m_146908_() - this.f_19859_ < -180.0f) {
            this.f_19859_ -= 360.0f;
        }
        while (this.m_146908_() - this.f_19859_ >= 180.0f) {
            this.f_19859_ += 360.0f;
        }
        this.m_146926_(Mth.m_14179_((float)0.2f, (float)this.f_19860_, (float)this.m_146909_()));
        this.m_146922_(Mth.m_14179_((float)0.2f, (float)this.f_19859_, (float)this.m_146908_()));
        if (this.m_20069_()) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, pos.f_82479_ - ourMotion.f_82479_ * 0.25, pos.f_82480_ - ourMotion.f_82480_ * 0.25, pos.f_82481_ - ourMotion.f_82481_ * 0.25, ourMotion.f_82479_, ourMotion.f_82480_, ourMotion.f_82481_);
            this.hasDrag();
            drag = 0.8f;
        } else {
            drag = 0.99f;
        }
        if (this.hasDrag()) {
            this.m_20256_(ourMotion.m_82490_((double)drag));
        }
        pos = this.m_20182_();
        this.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        if (!this.m_6084_()) {
            return;
        }
        ItemStack stack = this.getStack();
        boolean returning = this.isReturning();
        ++this.liveTime;
        LivingEntity owner = this.getThrower();
        if (owner == null || !owner.m_6084_() || !(owner instanceof Player)) {
            if (!this.m_9236_().f_46443_) {
                while (this.m_5830_()) {
                    this.m_6034_(this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_());
                }
                this.m_5552_(stack, 0.0f);
                this.m_146870_();
            }
            return;
        }
        if (!returning) {
            if (this.liveTime > 15) {
                this.setReturning();
            }
        } else {
            this.f_19794_ = true;
            List items = this.m_9236_().m_45976_(ItemEntity.class, this.m_20191_().m_82400_(1.0));
            List xp = this.m_9236_().m_45976_(ExperienceOrb.class, this.m_20191_().m_82400_(2.0));
            Vec3 ourPos = this.m_20182_();
            for (ItemEntity item : items) {
                if (item.m_20159_()) continue;
                item.m_20329_((Entity)this);
                item.m_32010_(5);
            }
            for (ExperienceOrb xpOrb : xp) {
                if (xpOrb.m_20159_()) continue;
                xpOrb.m_20329_((Entity)this);
            }
            Vec3 ownerPos = owner.m_20182_().m_82520_(0.0, 1.0, 0.0);
            Vec3 motion = ownerPos.m_82546_(ourPos);
            double motionMag = 3.5;
            if (motion.m_82556_() < motionMag) {
                Player player = (Player)owner;
                Inventory inventory = player.m_150109_();
                ItemStack stackInSlot = inventory.m_8020_(this.slot);
                if (!this.m_9236_().f_46443_) {
                    if (!stack.m_41619_()) {
                        if (player.m_6084_() && stackInSlot.m_41619_()) {
                            inventory.m_6836_(this.slot, stack);
                        } else if (!player.m_6084_() || !inventory.m_36054_(stack)) {
                            player.m_36176_(stack, false);
                        }
                    }
                    if (player.m_6084_()) {
                        for (ItemEntity item : items) {
                            if (!item.m_6084_()) continue;
                            this.giveItemToPlayer(player, item);
                        }
                        for (ExperienceOrb xpOrb : xp) {
                            if (!xpOrb.m_6084_()) continue;
                            xpOrb.m_6123_(player);
                        }
                        for (Entity riding : this.m_20197_()) {
                            if (!riding.m_6084_()) continue;
                            if (riding instanceof ItemEntity) {
                                this.giveItemToPlayer(player, (ItemEntity)riding);
                                continue;
                            }
                            if (!(riding instanceof ExperienceOrb)) continue;
                            riding.m_6123_(player);
                        }
                    }
                    ModMessages.sendToNearbyClients(new StopBoomerangSoundS2CPacket(player.m_19879_()), (ServerPlayer)player);
                    ModMessages.sendToPlayer(new StopBoomerangSoundS2CPacket(player.m_19879_()), (ServerPlayer)player);
                    this.m_146870_();
                }
            } else {
                this.m_20256_(motion.m_82541_().m_82490_(1.024999988079071));
            }
        }
    }

    protected void m_8060_(@NotNull BlockHitResult ray) {
        super.m_8060_(ray);
        this.setReturning();
        BlockPos blockPos = this.m_20183_();
        BlockState state = this.m_9236_().m_8055_(blockPos);
        Block block = state.m_60734_();
        if (block instanceof LeverBlock) {
            LeverBlock leverBlock = (LeverBlock)block;
            leverBlock.m_54676_(state, this.m_9236_(), blockPos);
        }
        if ((block = state.m_60734_()) instanceof ButtonBlock) {
            ButtonBlock buttonBlock = (ButtonBlock)block;
            buttonBlock.m_51116_(state, this.m_9236_(), blockPos);
        }
    }

    public void m_6123_(@NotNull Player pEntity) {
        if (this.m_150171_((Entity)pEntity) || this.m_19749_() == null) {
            super.m_6123_(pEntity);
        }
    }

    public void m_7378_(@Nonnull CompoundTag compound) {
        Tag owner;
        this.f_19804_.m_135381_(RETURNING, (Object)compound.m_128471_(TAG_RETURNING));
        this.liveTime = compound.m_128451_(TAG_LIVE_TIME);
        this.blockHitCount = compound.m_128451_(TAG_BLOCKS_BROKEN);
        this.slot = compound.m_128451_(TAG_RETURN_SLOT);
        if (compound.m_128441_(TAG_ITEM_STACK)) {
            this.setStack(ItemStack.m_41712_((CompoundTag)compound.m_128469_(TAG_ITEM_STACK)));
        } else {
            this.setStack(new ItemStack((ItemLike)ModItems.BOOMERANG.get()));
        }
        if (compound.m_128425_("owner", 10) && (owner = compound.m_128423_("owner")) != null) {
            this.ownerId = NbtUtils.m_129233_((Tag)owner);
        }
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_(TAG_RETURNING, this.isReturning());
        pCompound.m_128405_(TAG_LIVE_TIME, this.liveTime);
        pCompound.m_128405_(TAG_BLOCKS_BROKEN, this.blockHitCount);
        pCompound.m_128405_(TAG_RETURN_SLOT, this.slot);
        pCompound.m_128365_(TAG_ITEM_STACK, (Tag)this.getStack().serializeNBT());
        if (this.ownerId != null) {
            pCompound.m_128365_("owner", (Tag)NbtUtils.m_129226_((UUID)this.ownerId));
        }
    }

    public boolean m_6072_() {
        return false;
    }

    protected boolean m_5603_(Entity p_37135_) {
        return super.m_5603_(p_37135_) || p_37135_.m_6084_() && p_37135_ instanceof ItemEntity;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

