/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.entity.custom;

import java.util.Comparator;
import java.util.List;
import net.mezimaru.mastersword.entity.ModEntities;
import net.mezimaru.mastersword.item.ModItems;
import net.mezimaru.mastersword.particle.custom.ColoredParticleType;
import net.mezimaru.mastersword.util.FriendlyFireHelper;
import net.mezimaru.mastersword.util.ParticleHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class FairyArrowEntity
extends AbstractArrow {
    private LivingEntity target;
    private int homingDelay = 0;

    public FairyArrowEntity(EntityType<? extends AbstractArrow> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public FairyArrowEntity(LivingEntity pShooter, Level pLevel) {
        super((EntityType)ModEntities.FAIRY_ARROW.get(), pShooter, pLevel);
        this.m_5602_((Entity)pShooter);
        if (pShooter instanceof Player) {
            this.f_36705_ = AbstractArrow.Pickup.ALLOWED;
            this.m_36781_(3.0);
        }
    }

    public boolean m_36792_() {
        return false;
    }

    protected void m_5790_(EntityHitResult pResult) {
        super.m_5790_(pResult);
        double radius = 0.6;
        int amount = 60;
        if (this.getPersistentData().m_128471_("used_magic")) {
            this.spawnParticles(radius, amount);
        }
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getPersistentData().m_128471_("used_magic")) {
            if (this.homingDelay <= 3) {
                ++this.homingDelay;
            }
            if (this.homingDelay >= 3) {
                List livingEntities = this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_().m_82400_(8.0));
                this.target = livingEntities.stream().filter(entity -> FriendlyFireHelper.checkFriendlyFire(entity, (Player)this.m_19749_())).min(Comparator.comparingDouble(arg_0 -> ((FairyArrowEntity)this).m_20280_(arg_0))).orElse(null);
                if (this.target != null) {
                    Vec3 targetPosition = this.target.m_20182_();
                    Vec3 currentPosition = this.m_20182_();
                    Vec3 direction = targetPosition.m_82546_(currentPosition).m_82541_();
                    double speed = 1.0;
                    this.m_20256_(direction.m_82490_(speed));
                    this.m_20242_(true);
                    this.homingDelay = 0;
                } else if (this.m_20068_()) {
                    this.m_20242_(false);
                }
            }
            if (!this.m_20069_()) {
                if (this.f_36703_) {
                    if (this.f_36704_ % 5 == 0) {
                        this.spawnParticles(0.1, 1);
                    }
                } else if (this.f_19796_.m_188503_(100) < 50) {
                    this.spawnParticles(0.1, 3);
                }
            }
        }
    }

    private void spawnParticles(double radius, int amount) {
        float[][] colors = new float[][]{{1.0f, 0.549f, 0.953f}, {1.0f, 0.808f, 1.0f}, {0.98f, 0.745f, 0.98f}, {1.0f, 1.0f, 1.0f}};
        for (int i = 0; i < amount; ++i) {
            double offsetX = this.f_19796_.m_188583_() * radius;
            double offsetY = this.f_19796_.m_188583_() * radius;
            double offsetZ = this.f_19796_.m_188583_() * radius;
            int colorIndex = this.f_19796_.m_188503_(colors.length);
            float[] selectedColor = colors[colorIndex];
            double x = this.m_20185_() + offsetX;
            double y = this.m_20186_() + 0.1 + offsetY;
            double z = this.m_20189_() + offsetZ;
            ColoredParticleType.ColoredParticleData particleData = new ColoredParticleType.ColoredParticleData(selectedColor[0], selectedColor[1], selectedColor[2]);
            ParticleHelper.spawnParticle(this.f_19853_, particleData, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    protected ItemStack m_7941_() {
        return ((Item)ModItems.FAIRY_ARROW.get()).m_7968_();
    }
}

