/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.entity.custom;

import javax.annotation.Nullable;
import net.mezimaru.mastersword.config.MasterSwordCommonConfigs;
import net.mezimaru.mastersword.entity.ModEntities;
import net.mezimaru.mastersword.util.AbilityCapability;
import net.mezimaru.mastersword.util.AbilityCapabilityProvider;
import net.mezimaru.mastersword.util.FriendlyFireHelper;
import net.mezimaru.mastersword.util.ParticleHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class FireRodProjectileEntity
extends ThrowableProjectile {
    public FireRodProjectileEntity(EntityType<? extends ThrowableProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public FireRodProjectileEntity(LivingEntity pShooter, Level pLevel) {
        super((EntityType)ModEntities.FIRE_ROD_PROJECTILE.get(), pShooter, pLevel);
    }

    public static void onEntityHitAOEDamage(Player player, Level level, Entity hitEntity, FireRodProjectileEntity projectile) {
        if (level == null || hitEntity == null || level.f_46443_) {
            return;
        }
        AbilityCapability ability = (AbilityCapability)player.getCapability(AbilityCapabilityProvider.ABILITY_CAPABILITY).orElse(null);
        if (ability == null) {
            return;
        }
        AABB box = new AABB(hitEntity.m_20183_()).m_82400_(2.0);
        for (Entity entity : level.m_45933_(null, box)) {
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || !FriendlyFireHelper.checkFriendlyFire(livingEntity = (LivingEntity)entity, player)) continue;
            float damage = ((Double)MasterSwordCommonConfigs.FIRE_ROD_DAMAGE.get()).floatValue();
            livingEntity.m_6469_(level.m_269111_().m_269036_((Entity)player, (Entity)projectile), damage);
            livingEntity.m_20254_(3);
            double knockback = 1.5;
            double knockbackResistance = Math.max(0.0, 1.0 - livingEntity.m_21133_(Attributes.f_22278_));
            Vec3 vec3 = livingEntity.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_(knockback * 0.6 * knockbackResistance);
            if (!(vec3.m_82556_() > 0.0)) continue;
            livingEntity.m_5997_(vec3.f_82479_, 0.1, vec3.f_82481_);
        }
    }

    public static void onBlockHitAOEDamage(Player player, Level level, BlockPos hitPos, FireRodProjectileEntity projectile) {
        if (!level.f_46443_) {
            AbilityCapability ability = (AbilityCapability)player.getCapability(AbilityCapabilityProvider.ABILITY_CAPABILITY).orElse(null);
            if (ability == null) {
                return;
            }
            AABB box = new AABB(hitPos).m_82400_(2.0);
            for (Entity entity : level.m_45933_(null, box)) {
                LivingEntity livingEntity;
                if (!(entity instanceof LivingEntity) || !FriendlyFireHelper.checkFriendlyFire(livingEntity = (LivingEntity)entity, player)) continue;
                float damage = ((Double)MasterSwordCommonConfigs.FIRE_ROD_DAMAGE.get()).floatValue();
                livingEntity.m_6469_(level.m_269111_().m_269036_((Entity)player, (Entity)projectile), damage);
                double knockback = 1.5;
                double knockbackResistance = Math.max(0.0, 1.0 - livingEntity.m_21133_(Attributes.f_22278_));
                Vec3 vec3 = livingEntity.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_(knockback * 0.6 * knockbackResistance);
                if (!(vec3.m_82556_() > 0.0)) continue;
                livingEntity.m_5997_(vec3.f_82479_, 0.1, vec3.f_82481_);
            }
        }
    }

    protected float m_7139_() {
        return 0.0f;
    }

    protected void m_8097_() {
    }

    protected AABB m_142242_() {
        float width = 1.0f;
        float height = 0.7f;
        float yOffset = -0.7f;
        double minX = this.m_20185_() - (double)(width / 2.0f);
        double minY = this.m_20186_() + (double)yOffset;
        double minZ = this.m_20189_() - (double)(width / 2.0f);
        double maxX = this.m_20185_() + (double)(width / 2.0f);
        double maxY = this.m_20186_() + (double)height + (double)yOffset;
        double maxZ = this.m_20189_() + (double)(width / 2.0f);
        return new AABB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    protected float m_6380_(Pose pPose, EntityDimensions pDimensions) {
        return pDimensions.f_20378_ - 2.2f;
    }

    public void m_8119_() {
        HitResult hitresult = ProjectileUtil.m_278158_((Entity)this, x$0 -> this.m_5603_((Entity)x$0));
        if (hitresult.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
            this.m_6532_(hitresult);
        }
        this.m_20101_();
        Vec3 vec3 = this.m_20184_();
        double d2 = this.m_20185_() + vec3.f_82479_;
        double d0 = this.m_20186_() + vec3.f_82480_;
        double d1 = this.m_20189_() + vec3.f_82481_;
        this.m_37283_();
        if (this.m_20069_()) {
            this.m_146870_();
            return;
        }
        float f = 0.99f;
        this.m_20256_(vec3.m_82490_((double)f));
        this.m_6034_(d2, d0, d1);
        if (this.f_19797_ >= 45) {
            this.m_146870_();
            return;
        }
        this.makeTrail(0.0, 0.0, 0.0, 2);
    }

    public boolean m_6087_() {
        return false;
    }

    public void makeTrail(double r, double g, double b, int amount) {
        for (int i = 0; i < amount; ++i) {
            double dx = this.m_20185_() + 1.0 * (this.f_19796_.m_188500_() - this.f_19796_.m_188500_());
            double dy = this.m_20186_() + 0.3 * (this.f_19796_.m_188500_() - this.f_19796_.m_188500_());
            double dz = this.m_20189_() + 1.0 * (this.f_19796_.m_188500_() - this.f_19796_.m_188500_());
            ParticleHelper.spawnParticle(this.f_19853_, (ParticleOptions)ParticleTypes.f_123744_, dx, dy - 0.2, dz, r, g, b);
            ParticleHelper.spawnParticle(this.f_19853_, (ParticleOptions)ParticleTypes.f_123784_, dx, dy - 0.2, dz, r, g, b);
        }
    }

    private void spawnExplosionParticles(Player player, double x, double y, double z) {
        AbilityCapability ability = (AbilityCapability)player.getCapability(AbilityCapabilityProvider.ABILITY_CAPABILITY).orElse(null);
        if (ability == null) {
            return;
        }
        double radius = 1.0;
        int amount = 150;
        for (int i = 0; i < amount; ++i) {
            double offsetX = this.f_19796_.m_188583_() * radius;
            double offsetY = this.f_19796_.m_188583_() * radius;
            double offsetZ = this.f_19796_.m_188583_() * radius;
            ParticleHelper.spawnParticle(this.f_19853_, (ParticleOptions)ParticleTypes.f_123756_, x + offsetX, y + offsetY, z + offsetZ, 0.0, 0.0, 0.0);
            ParticleHelper.spawnParticle(this.f_19853_, (ParticleOptions)ParticleTypes.f_123762_, x + offsetX, y + offsetY, z + offsetZ, 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    private Player getShooter() {
        Entity owner = this.m_19749_();
        if (owner instanceof Player) {
            return (Player)owner;
        }
        return null;
    }

    protected void m_5790_(EntityHitResult pResult) {
        super.m_5790_(pResult);
        if (this.f_19853_.m_5776_()) {
            return;
        }
        Entity targetEntity = pResult.m_82443_();
        if (!(targetEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)targetEntity;
        Player player = this.getShooter();
        if (player == null) {
            return;
        }
        if (pResult.m_82443_() != this.getShooter() && FriendlyFireHelper.checkFriendlyFire(livingEntity, player)) {
            double hitX = pResult.m_82450_().m_7096_();
            double hitY = pResult.m_82450_().m_7098_();
            double hitZ = pResult.m_82450_().m_7094_();
            this.spawnExplosionParticles(player, hitX, hitY, hitZ);
            FireRodProjectileEntity.onEntityHitAOEDamage(player, this.f_19853_, (Entity)livingEntity, this);
            this.m_9236_().m_255391_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), ((Double)MasterSwordCommonConfigs.FIRE_ROD_EXPLOSION.get()).floatValue(), ((Boolean)MasterSwordCommonConfigs.FIRE_ROD_CAUSE_FIRES.get()).booleanValue(), Level.ExplosionInteraction.MOB);
            this.m_146870_();
        }
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        if (this.f_19853_.m_5776_()) {
            return;
        }
        Player player = this.getShooter();
        if (player == null) {
            return;
        }
        double hitX = blockHitResult.m_82450_().m_7096_();
        double hitY = blockHitResult.m_82450_().m_7098_();
        double hitZ = blockHitResult.m_82450_().m_7094_();
        this.spawnExplosionParticles(player, hitX, hitY, hitZ);
        FireRodProjectileEntity.onBlockHitAOEDamage(player, this.f_19853_, blockHitResult.m_82425_(), this);
        this.m_9236_().m_255391_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), ((Double)MasterSwordCommonConfigs.FIRE_ROD_EXPLOSION.get()).floatValue(), ((Boolean)MasterSwordCommonConfigs.FIRE_ROD_CAUSE_FIRES.get()).booleanValue(), Level.ExplosionInteraction.MOB);
        this.m_146870_();
    }
}

