/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.entity.custom;

import javax.annotation.Nullable;
import net.mezimaru.mastersword.config.MasterSwordCommonConfigs;
import net.mezimaru.mastersword.entity.ModEntities;
import net.mezimaru.mastersword.item.custom.TrueMasterSwordItem;
import net.mezimaru.mastersword.network.ModMessages;
import net.mezimaru.mastersword.network.packet.StopBeamHumSoundS2CPacket;
import net.mezimaru.mastersword.particle.custom.ColoredParticleType;
import net.mezimaru.mastersword.sound.ModSounds;
import net.mezimaru.mastersword.util.FriendlyFireHelper;
import net.mezimaru.mastersword.util.ParticleHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class SwordBeamProjectileEntity
extends ThrowableProjectile {
    public SwordBeamProjectileEntity(EntityType<? extends ThrowableProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public SwordBeamProjectileEntity(LivingEntity pShooter, Level pLevel) {
        super((EntityType)ModEntities.SWORDBEAM.get(), pShooter, pLevel);
    }

    private static boolean isUndeadMob(Entity entity) {
        if (entity instanceof Mob) {
            Mob hitMob = (Mob)entity;
            MobType entityType = hitMob.m_6336_();
            return entityType == MobType.f_21641_;
        }
        return false;
    }

    private static boolean usingTrueMasterSword(Player player) {
        return player.m_21205_().m_41720_() instanceof TrueMasterSwordItem;
    }

    public void onEntityHitAOEDamage(Player player, Level level, Entity hitEntity) {
        boolean flash;
        double radius;
        CompoundTag persistTag;
        boolean hasCielaOrGolden;
        if (level == null || hitEntity == null || level.f_46443_) {
            return;
        }
        CompoundTag tag = player.getPersistentData();
        if (!tag.m_128441_("PlayerPersisted")) {
            tag.m_128365_("PlayerPersisted", (Tag)new CompoundTag());
        }
        boolean bl = hasCielaOrGolden = (persistTag = tag.m_128469_("PlayerPersisted")).m_128471_("hasPetFairy") && (persistTag.m_128461_("fairyType").equals("ciela") || persistTag.m_128461_("fairyType").equals("golden"));
        if (hasCielaOrGolden) {
            radius = 2.5;
            flash = true;
        } else {
            radius = 1.5;
            flash = false;
        }
        AABB box = new AABB(hitEntity.m_20183_()).m_82400_(radius);
        for (Entity entity : level.m_45933_(null, box)) {
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || !FriendlyFireHelper.checkFriendlyFire(livingEntity = (LivingEntity)entity, player)) continue;
            float damage = hasCielaOrGolden ? (SwordBeamProjectileEntity.isUndeadMob((Entity)livingEntity) && SwordBeamProjectileEntity.usingTrueMasterSword(player) ? ((Double)MasterSwordCommonConfigs.ENHANCED_BEAM_DAMAGE.get()).floatValue() + 3.0f : ((Double)MasterSwordCommonConfigs.ENHANCED_BEAM_DAMAGE.get()).floatValue()) : (SwordBeamProjectileEntity.isUndeadMob((Entity)livingEntity) && SwordBeamProjectileEntity.usingTrueMasterSword(player) ? ((Double)MasterSwordCommonConfigs.BASE_BEAM_DAMAGE.get()).floatValue() + 2.0f : ((Double)MasterSwordCommonConfigs.BASE_BEAM_DAMAGE.get()).floatValue());
            livingEntity.m_6469_(level.m_269111_().m_269104_((Entity)player, (Entity)this), damage);
            if (livingEntity.getPersistentData().m_128441_("lastKnockbackTime") && level.m_46467_() - livingEntity.getPersistentData().m_128454_("lastKnockbackTime") <= 10L) continue;
            double knockback = 0.5;
            double knockbackResistance = Math.max(0.0, 1.0 - livingEntity.m_21133_(Attributes.f_22278_));
            Vec3 vec3 = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_(knockback * 0.6 * knockbackResistance);
            if (!(vec3.m_82556_() > 0.0)) continue;
            livingEntity.m_5997_(vec3.f_82479_, 0.1, vec3.f_82481_);
        }
        if (flash) {
            ParticleHelper.spawnParticle(level, (ParticleOptions)ParticleTypes.f_123747_, hitEntity.m_20185_(), hitEntity.m_20186_(), hitEntity.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    public void onBlockHitAOEDamage(Player player, Level level, BlockPos hitPos) {
        if (!level.f_46443_) {
            boolean flash;
            double radius;
            CompoundTag persistTag;
            boolean hasCielaOrGolden;
            CompoundTag tag = player.getPersistentData();
            if (!tag.m_128441_("PlayerPersisted")) {
                tag.m_128365_("PlayerPersisted", (Tag)new CompoundTag());
            }
            boolean bl = hasCielaOrGolden = (persistTag = tag.m_128469_("PlayerPersisted")).m_128471_("hasPetFairy") && (persistTag.m_128461_("fairyType").equals("ciela") || persistTag.m_128461_("fairyType").equals("golden"));
            if (hasCielaOrGolden) {
                radius = 2.5;
                flash = true;
            } else {
                radius = 1.5;
                flash = false;
            }
            AABB box = new AABB(hitPos).m_82400_(radius);
            for (Entity entity : level.m_45933_(null, box)) {
                LivingEntity livingEntity;
                if (!(entity instanceof LivingEntity) || !FriendlyFireHelper.checkFriendlyFire(livingEntity = (LivingEntity)entity, player)) continue;
                float damage = hasCielaOrGolden ? (SwordBeamProjectileEntity.isUndeadMob((Entity)livingEntity) && SwordBeamProjectileEntity.usingTrueMasterSword(player) ? ((Double)MasterSwordCommonConfigs.ENHANCED_BEAM_DAMAGE.get()).floatValue() + 3.0f : ((Double)MasterSwordCommonConfigs.ENHANCED_BEAM_DAMAGE.get()).floatValue()) : (SwordBeamProjectileEntity.isUndeadMob((Entity)livingEntity) && SwordBeamProjectileEntity.usingTrueMasterSword(player) ? ((Double)MasterSwordCommonConfigs.BASE_BEAM_DAMAGE.get()).floatValue() + 2.0f : ((Double)MasterSwordCommonConfigs.BASE_BEAM_DAMAGE.get()).floatValue());
                livingEntity.m_6469_(level.m_269111_().m_269104_((Entity)player, (Entity)this), damage);
                double knockback = 0.5;
                double knockbackResistance = Math.max(0.0, 1.0 - livingEntity.m_21133_(Attributes.f_22278_));
                Vec3 vec3 = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_(knockback * 0.6 * knockbackResistance);
                if (!(vec3.m_82556_() > 0.0)) continue;
                livingEntity.m_5997_(vec3.f_82479_, 0.1, vec3.f_82481_);
            }
            if (flash) {
                ParticleHelper.spawnParticle(level, (ParticleOptions)ParticleTypes.f_123747_, hitPos.m_123341_(), hitPos.m_123342_(), hitPos.m_123343_(), 0.0, 0.0, 0.0);
            }
        }
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.f_19853_.m_6269_(null, (Entity)this, (SoundEvent)ModSounds.BEAM_HUM.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    protected float m_7139_() {
        return 0.0f;
    }

    protected void m_8097_() {
    }

    protected AABB m_142242_() {
        float width = 1.8f;
        float height = 0.35f;
        float yOffset = -0.2f;
        double minX = this.m_20185_() - (double)(width / 2.0f);
        double minY = this.m_20186_() + (double)yOffset;
        double minZ = this.m_20189_() - (double)(width / 2.0f);
        double maxX = this.m_20185_() + (double)(width / 2.0f);
        double maxY = this.m_20186_() + (double)height + (double)yOffset;
        double maxZ = this.m_20189_() + (double)(width / 2.0f);
        return new AABB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    protected float m_6380_(Pose pPose, EntityDimensions pDimensions) {
        return pDimensions.f_20378_ - 1.8f;
    }

    public void m_8119_() {
        float f;
        HitResult hitresult = ProjectileUtil.m_278158_((Entity)this, x$0 -> this.m_5603_((Entity)x$0));
        if (hitresult.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
            this.m_6532_(hitresult);
        }
        this.m_20101_();
        Vec3 vec3 = this.m_20184_();
        double d2 = this.m_20185_() + vec3.f_82479_;
        double d0 = this.m_20186_() + vec3.f_82480_;
        double d1 = this.m_20189_() + vec3.f_82481_;
        this.m_37283_();
        if (this.m_20069_()) {
            for (int i = 0; i < 4; ++i) {
                ParticleHelper.spawnParticle(this.f_19853_, (ParticleOptions)ParticleTypes.f_123795_, d2 - vec3.f_82479_ * 0.25, d0 - vec3.f_82480_ * 0.25, d1 - vec3.f_82481_ * 0.25, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            }
            f = 0.8f;
        } else {
            f = 0.99f;
        }
        this.m_20256_(vec3.m_82490_((double)f));
        this.m_6034_(d2, d0, d1);
        if (this.f_19797_ >= 45) {
            this.m_146870_();
            return;
        }
        Entity entity = this.m_19749_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.makeTrail(player);
        }
    }

    public boolean m_6087_() {
        return false;
    }

    public void makeTrail(Player player) {
        if (!this.f_19853_.f_46443_) {
            CompoundTag persistTag;
            CompoundTag tag = player.getPersistentData();
            if (!tag.m_128441_("PlayerPersisted")) {
                tag.m_128365_("PlayerPersisted", (Tag)new CompoundTag());
            }
            boolean hasCielaOrGolden = (persistTag = tag.m_128469_("PlayerPersisted")).m_128471_("hasPetFairy") && (persistTag.m_128461_("fairyType").equals("ciela") || persistTag.m_128461_("fairyType").equals("golden"));
            int amount = hasCielaOrGolden ? 10 : 5;
            for (int i = 0; i < amount; ++i) {
                ColoredParticleType.ColoredParticleData particleData;
                double dx = this.m_20185_() + 1.0 * (this.f_19796_.m_188500_() - this.f_19796_.m_188500_());
                double dy = this.m_20186_() + 0.3 * (this.f_19796_.m_188500_() - this.f_19796_.m_188500_());
                double dz = this.m_20189_() + 1.0 * (this.f_19796_.m_188500_() - this.f_19796_.m_188500_());
                if (hasCielaOrGolden) {
                    particleData = new ColoredParticleType.ColoredParticleData(0.678f, 0.847f, 0.902f);
                    ParticleHelper.spawnParticle(this.f_19853_, particleData, dx, dy, dz, 0.0, 0.0, 0.0);
                    continue;
                }
                particleData = new ColoredParticleType.ColoredParticleData(0.1804f, 0.4902f, 1.0f);
                ParticleHelper.spawnParticle(this.f_19853_, particleData, dx, dy, dz, 0.0, 0.0, 0.0);
            }
        }
    }

    private void spawnBlueExplosionParticles(Player player, double x, double y, double z) {
        int amount;
        double radius;
        CompoundTag persistTag;
        boolean hasCielaOrGolden;
        CompoundTag tag = player.getPersistentData();
        if (!tag.m_128441_("PlayerPersisted")) {
            tag.m_128365_("PlayerPersisted", (Tag)new CompoundTag());
        }
        boolean bl = hasCielaOrGolden = (persistTag = tag.m_128469_("PlayerPersisted")).m_128471_("hasPetFairy") && (persistTag.m_128461_("fairyType").equals("ciela") || persistTag.m_128461_("fairyType").equals("golden"));
        if (hasCielaOrGolden) {
            radius = 1.5;
            amount = 250;
        } else {
            radius = 1.0;
            amount = 150;
        }
        for (int i = 0; i < amount; ++i) {
            ColoredParticleType.ColoredParticleData particleData;
            double offsetX = this.f_19796_.m_188583_() * radius;
            double offsetY = this.f_19796_.m_188583_() * radius;
            double offsetZ = this.f_19796_.m_188583_() * radius;
            if (hasCielaOrGolden) {
                ParticleHelper.spawnParticle(this.f_19853_, (ParticleOptions)ParticleTypes.f_123772_, x + offsetX, y + offsetY, z + offsetZ, 0.0, 0.0, 0.0);
                particleData = new ColoredParticleType.ColoredParticleData(0.678f, 0.847f, 0.902f);
                ParticleHelper.spawnParticle(this.f_19853_, particleData, x + offsetX, y + offsetY, z + offsetZ, 0.0, 0.0, 0.0);
                continue;
            }
            particleData = new ColoredParticleType.ColoredParticleData(0.1804f, 0.4902f, 1.0f);
            ParticleHelper.spawnParticle(this.f_19853_, particleData, x + offsetX, y + offsetY, z + offsetZ, 0.0, 0.0, 0.0);
        }
        this.f_19853_.m_6263_(null, x, y, z, (SoundEvent)ModSounds.BEAM_IMPACT.get(), SoundSource.NEUTRAL, 0.5f, 1.0f);
    }

    @Nullable
    private Player getShooter() {
        Entity owner = this.m_19749_();
        if (owner instanceof Player) {
            return (Player)owner;
        }
        return null;
    }

    protected void m_5790_(EntityHitResult pResult) {
        super.m_5790_(pResult);
        if (this.f_19853_.m_5776_()) {
            return;
        }
        Entity targetEntity = pResult.m_82443_();
        if (!(targetEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)targetEntity;
        Player player = this.getShooter();
        if (player == null) {
            return;
        }
        if (pResult.m_82443_() != this.getShooter() && FriendlyFireHelper.checkFriendlyFire(livingEntity, player)) {
            double hitX = pResult.m_82450_().m_7096_();
            double hitY = pResult.m_82450_().m_7098_();
            double hitZ = pResult.m_82450_().m_7094_();
            this.spawnBlueExplosionParticles(player, hitX, hitY, hitZ);
            this.onEntityHitAOEDamage(player, this.f_19853_, (Entity)livingEntity);
            ModMessages.sendToNearbyClients(new StopBeamHumSoundS2CPacket(player.m_19879_()), (ServerPlayer)player);
            ModMessages.sendToPlayer(new StopBeamHumSoundS2CPacket(player.m_19879_()), (ServerPlayer)player);
            this.m_146870_();
        }
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        if (this.f_19853_.m_5776_()) {
            return;
        }
        Player player = this.getShooter();
        if (player == null) {
            return;
        }
        double hitX = blockHitResult.m_82450_().m_7096_();
        double hitY = blockHitResult.m_82450_().m_7098_();
        double hitZ = blockHitResult.m_82450_().m_7094_();
        this.spawnBlueExplosionParticles(player, hitX, hitY, hitZ);
        this.onBlockHitAOEDamage(player, this.f_19853_, blockHitResult.m_82425_());
        ModMessages.sendToNearbyClients(new StopBeamHumSoundS2CPacket(player.m_19879_()), (ServerPlayer)player);
        ModMessages.sendToPlayer(new StopBeamHumSoundS2CPacket(player.m_19879_()), (ServerPlayer)player);
        this.m_146870_();
    }
}

