/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.entity.custom;

import net.mezimaru.mastersword.entity.custom.BasePetFairyEntity;
import net.mezimaru.mastersword.util.ParticleHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.storage.LevelData;

public class TaelFairyEntity
extends BasePetFairyEntity {
    private int canRemoveDebuffCounter = 5000;

    public TaelFairyEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.m_7105_(true);
    }

    public static boolean canTaelSpawn(EntityType<TaelFairyEntity> entityType, LevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        return pRandom.m_188503_(10) == 0 && TaelFairyEntity.isRainingOrStorming(pLevel);
    }

    private static boolean isRainingOrStorming(LevelAccessor level) {
        LevelData leveldata = level.m_6106_();
        return leveldata.m_6533_() || leveldata.m_6534_();
    }

    @Override
    public void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(2, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.1, 5.0f, 1.0f, true));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 0.8));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        LivingEntity owner = this.m_269323_();
        Player player = (Player)owner;
        if (player != null && this.canRemoveDebuff(player)) {
            this.removeDebuff(player);
            this.canRemoveDebuffCounter = 0;
        }
    }

    private boolean canRemoveDebuff(Player player) {
        if (this.canRemoveDebuffCounter < 6000) {
            ++this.canRemoveDebuffCounter;
            return false;
        }
        return this.hasDebuff(player);
    }

    private boolean hasDebuff(Player player) {
        return player.m_21023_(MobEffects.f_19597_) || player.m_21023_(MobEffects.f_19614_) || player.m_21023_(MobEffects.f_19615_) || player.m_21023_(MobEffects.f_19610_) || player.m_21023_(MobEffects.f_19604_) || player.m_21023_(MobEffects.f_216964_) || player.m_21023_(MobEffects.f_19599_) || player.m_21023_(MobEffects.f_19612_) || player.m_21023_(MobEffects.f_19613_);
    }

    private void removeDebuff(Player player) {
        if (player.m_21023_(MobEffects.f_19597_)) {
            player.m_21195_(MobEffects.f_19597_);
        } else if (player.m_21023_(MobEffects.f_19614_)) {
            player.m_21195_(MobEffects.f_19614_);
        } else if (player.m_21023_(MobEffects.f_19615_)) {
            player.m_21195_(MobEffects.f_19615_);
        } else if (player.m_21023_(MobEffects.f_19610_)) {
            player.m_21195_(MobEffects.f_19610_);
        } else if (player.m_21023_(MobEffects.f_19604_)) {
            player.m_21195_(MobEffects.f_19604_);
        } else if (player.m_21023_(MobEffects.f_216964_)) {
            player.m_21195_(MobEffects.f_216964_);
        } else if (player.m_21023_(MobEffects.f_19599_)) {
            player.m_21195_(MobEffects.f_19599_);
        } else if (player.m_21023_(MobEffects.f_19612_)) {
            player.m_21195_(MobEffects.f_19612_);
        } else if (player.m_21023_(MobEffects.f_19613_)) {
            player.m_21195_(MobEffects.f_19613_);
        }
        double x = player.m_20185_();
        double y = player.m_20186_() + 1.0;
        double z = player.m_20189_();
        for (int i = 0; i < 60; ++i) {
            double angle = (double)i / 30.0 * Math.PI * 2.0;
            double px = Math.cos(angle) * 0.5;
            double pz = Math.sin(angle) * 0.5;
            ParticleHelper.spawnParticle(this.f_19853_, (ParticleOptions)ParticleTypes.f_123785_, x + px, y, z + pz, 0.0, 0.5, 0.0);
        }
    }
}

