/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.events;

import net.mezimaru.mastersword.client.MagicMeterData;
import net.mezimaru.mastersword.item.ModItems;
import net.mezimaru.mastersword.network.ModMessages;
import net.mezimaru.mastersword.network.packet.MagicMeterSyncS2CPacket;
import net.mezimaru.mastersword.util.IMagicItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="mastersword")
public class MagicMeterEvents {
    public static CompoundTag getOrCreatePersistentTag(Player player) {
        CompoundTag tag = player.getPersistentData();
        if (!tag.m_128441_("PlayerPersisted")) {
            tag.m_128365_("PlayerPersisted", (Tag)new CompoundTag());
        }
        return tag.m_128469_("PlayerPersisted");
    }

    @SubscribeEvent
    public static void onItemPickup(PlayerEvent.ItemPickupEvent event) {
        Player player;
        ItemStack pickedUpItem = event.getStack();
        if (pickedUpItem.m_41720_().equals(ModItems.MAGIC_JAR.get()) && (player = event.getEntity()) != null && player.m_6084_() && !player.f_19853_.f_46443_) {
            MagicMeterEvents.addMagic(15, (ServerPlayer)player);
            pickedUpItem.m_41774_(1);
        }
    }

    public static void addMagic(int amount, ServerPlayer player) {
        int maxMagic;
        int currentAmount = MagicMeterData.getMagicAmount((Player)player);
        int newAmount = currentAmount + amount;
        if (newAmount <= (maxMagic = MagicMeterData.getMaxMagic((Player)player))) {
            MagicMeterData.setMagicAmount((Player)player, newAmount);
            ModMessages.sendToPlayer(new MagicMeterSyncS2CPacket(newAmount, maxMagic, 100, player.m_19879_()), player);
        } else {
            MagicMeterData.setMagicAmount((Player)player, maxMagic);
            ModMessages.sendToPlayer(new MagicMeterSyncS2CPacket(maxMagic, maxMagic, 100, player.m_19879_()), player);
        }
    }

    public static void removeMagic(int amount, ServerPlayer player) {
        if (!player.m_7500_()) {
            int currentAmount = MagicMeterData.getMagicAmount((Player)player);
            int newAmount = currentAmount - amount;
            if (newAmount >= 0) {
                MagicMeterData.setMagicAmount((Player)player, newAmount);
                ModMessages.sendToPlayer(new MagicMeterSyncS2CPacket(newAmount, MagicMeterData.getMaxMagic((Player)player), 100, player.m_19879_()), player);
            } else {
                MagicMeterData.setMagicAmount((Player)player, 0);
                ModMessages.sendToPlayer(new MagicMeterSyncS2CPacket(0, MagicMeterData.getMaxMagic((Player)player), 100, player.m_19879_()), player);
            }
        }
    }

    @SubscribeEvent
    public static void renderMagicMeterWhenNeeded(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase == TickEvent.Phase.START && (player = event.player).m_6084_()) {
            int newTimerValue;
            Item mainItem = player.m_21120_(InteractionHand.MAIN_HAND).m_41720_();
            Item offItem = player.m_21120_(InteractionHand.OFF_HAND).m_41720_();
            int magicAmount = MagicMeterData.getMagicAmount(player);
            int maxMagic = MagicMeterData.getMaxMagic(player);
            int currentRenderTimer = MagicMeterData.getWhenNeededRenderTimer(player);
            int n = newTimerValue = mainItem instanceof IMagicItem || offItem instanceof IMagicItem ? 100 : Math.max(currentRenderTimer - 1, 0);
            if (newTimerValue != currentRenderTimer) {
                MagicMeterData.setWhenNeededRenderTimer(player, newTimerValue);
                if (!event.side.isClient()) {
                    ModMessages.sendToPlayer(new MagicMeterSyncS2CPacket(magicAmount, maxMagic, newTimerValue, player.m_19879_()), (ServerPlayer)player);
                }
            }
        }
    }

    private static void saveMagicData(ServerPlayer player) {
        MagicMeterData.setMagicAmount((Player)player, MagicMeterData.getMagicAmount((Player)player));
        CompoundTag tag = MagicMeterEvents.getOrCreatePersistentTag((Player)player);
        tag.m_128405_("max_magic", MagicMeterData.getMaxMagic((Player)player));
        tag.m_128405_("magic_amount", MagicMeterData.getMagicAmount((Player)player));
    }

    private static void loadMagicData(ServerPlayer player) {
        CompoundTag tag = MagicMeterEvents.getOrCreatePersistentTag((Player)player);
        if (tag.m_128441_("magic_amount")) {
            MagicMeterData.setMagicAmount((Player)player, tag.m_128451_("magic_amount"));
        } else {
            MagicMeterData.setMagicAmount((Player)player, 0);
        }
        MagicMeterData.setWhenNeededRenderTimer((Player)player, 100);
        if (tag.m_128441_("max_magic")) {
            MagicMeterData.setMaxMagic((Player)player, tag.m_128451_("max_magic"));
        } else {
            MagicMeterData.setMaxMagic((Player)player, 100);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Level level = event.getEntity().f_19853_;
        if (!level.f_46443_) {
            MagicMeterEvents.saveMagicData((ServerPlayer)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Level level = event.getEntity().f_19853_;
        if (!level.f_46443_) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            MagicMeterEvents.loadMagicData(player);
            MagicMeterEvents.syncMagicDataToClient(player);
        }
    }

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            MagicMeterEvents.loadMagicData(player);
            MagicMeterEvents.syncMagicDataToClient(player);
        }
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        for (ServerPlayer player : event.getServer().m_6846_().m_11314_()) {
            MagicMeterEvents.saveMagicData(player);
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            MagicMeterEvents.saveMagicData(player);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        MagicMeterEvents.loadMagicData(player);
        MagicMeterEvents.syncMagicDataToClient(player);
    }

    private static void syncMagicDataToClient(ServerPlayer player) {
        int magicAmount = MagicMeterData.getMagicAmount((Player)player);
        int maxMagic = MagicMeterData.getMaxMagic((Player)player);
        int renderTimer = MagicMeterData.getWhenNeededRenderTimer((Player)player);
        ModMessages.sendToPlayer(new MagicMeterSyncS2CPacket(magicAmount, maxMagic, renderTimer, player.m_19879_()), player);
    }
}

