/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.events;

import net.mezimaru.mastersword.block.entity.SwordShrineBlockEntity;
import net.mezimaru.mastersword.client.MagicMeterData;
import net.mezimaru.mastersword.config.MasterSwordCommonConfigs;
import net.mezimaru.mastersword.entity.custom.MagicJarPickupItemEntity;
import net.mezimaru.mastersword.item.ModItems;
import net.mezimaru.mastersword.item.custom.BlueRupeeItem;
import net.mezimaru.mastersword.item.custom.GoldRupeeItem;
import net.mezimaru.mastersword.item.custom.GreenRupeeItem;
import net.mezimaru.mastersword.item.custom.PurpleRupeeItem;
import net.mezimaru.mastersword.item.custom.RedRupeeItem;
import net.mezimaru.mastersword.item.custom.SilverRupeeItem;
import net.mezimaru.mastersword.network.ModMessages;
import net.mezimaru.mastersword.network.packet.RupeePickupSoundEventS2CPacket;
import net.mezimaru.mastersword.sound.ModSounds;
import net.mezimaru.mastersword.util.AbilityCapability;
import net.mezimaru.mastersword.util.AbilityCapabilityProvider;
import net.mezimaru.mastersword.util.ParticleHelper;
import net.mezimaru.mastersword.util.TriforceWishCommand;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.MissingMappingsEvent;

@Mod.EventBusSubscriber(modid="mastersword")
public class ModEvents {
    @SubscribeEvent
    public static void onItemToss(ItemTossEvent event) {
        Player player = event.getPlayer();
        ItemEntity itemEntity = event.getEntity();
        CompoundTag nbt = itemEntity.m_32055_().m_41784_();
        nbt.m_128359_("TosserUUID", player.m_20148_().toString());
        itemEntity.m_32055_().m_41751_(nbt);
    }

    @SubscribeEvent
    public static void onItemPickup(PlayerEvent.ItemPickupEvent event) {
        ItemStack itemStack = event.getStack();
        CompoundTag nbt = itemStack.m_41783_();
        if (nbt != null && nbt.m_128441_("TosserUUID")) {
            nbt.m_128473_("TosserUUID");
            if (nbt.m_128456_()) {
                itemStack.m_41751_(null);
            }
        }
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register(TriforceWishCommand.register());
    }

    @SubscribeEvent
    public static void onMissingMappings(MissingMappingsEvent event) {
        if (event.getKey().equals((Object)ForgeRegistries.ITEMS.getRegistryKey())) {
            for (MissingMappingsEvent.Mapping mapping : event.getAllMappings(ForgeRegistries.ITEMS.getRegistryKey())) {
                if (!mapping.getKey().m_135815_().equals("hero_shield")) continue;
                mapping.remap((Object)((Item)ModItems.FIGHTERS_SHIELD.get()));
            }
        }
    }

    @SubscribeEvent
    public static void onAttachCapabilitiesPlayer(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player && !((Entity)event.getObject()).getCapability(AbilityCapabilityProvider.ABILITY_CAPABILITY).isPresent()) {
            event.addCapability(new ResourceLocation("mastersword", "spinproperties"), (ICapabilityProvider)new AbilityCapabilityProvider());
        }
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            event.getOriginal().reviveCaps();
            event.getOriginal().getCapability(AbilityCapabilityProvider.ABILITY_CAPABILITY).ifPresent(oldStore -> event.getEntity().getCapability(AbilityCapabilityProvider.ABILITY_CAPABILITY).ifPresent(newStore -> newStore.copySpinFrom((AbilityCapability)oldStore)));
            event.getOriginal().invalidateCaps();
        }
    }

    @SubscribeEvent
    public static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.register(AbilityCapability.class);
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && !(player = (Player)livingEntity).m_7500_() && !player.m_5833_()) {
            for (int slot = 0; slot < player.f_36093_.m_6643_(); ++slot) {
                ItemStack slotStack = player.f_36093_.m_8020_(slot);
                if (!ItemStack.m_41656_((ItemStack)slotStack, (ItemStack)new ItemStack((ItemLike)ModItems.HYLIAN_BOTTLE_HEALING_FAIRY.get()))) continue;
                player.f_36093_.m_36057_(slotStack);
                Level level = player.f_19853_;
                event.setCanceled(true);
                player.m_21153_(8.0f);
                player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 120));
                player.f_36093_.m_36054_(new ItemStack((ItemLike)ModItems.HYLIAN_BOTTLE.get(), 1));
                level.m_6269_(null, (Entity)player, (SoundEvent)ModSounds.FAIRY_HEAL.get(), SoundSource.NEUTRAL, 1.2f, 1.0f);
                double x = player.m_20185_();
                double y = player.m_20186_() + 1.0;
                double z = player.m_20189_();
                for (int i = 0; i < 60; ++i) {
                    double angle = (double)i / 30.0 * Math.PI * 2.0;
                    double px = Math.cos(angle) * 0.5;
                    double pz = Math.sin(angle) * 0.5;
                    ParticleHelper.spawnParticle(level, (ParticleOptions)ParticleTypes.f_123784_, x + px, y, z + pz, 0.0, 0.5, 0.0);
                }
                break;
            }
        }
    }

    @SubscribeEvent
    public static void grantPlayerInitialAdvancement(PlayerEvent.PlayerLoggedInEvent event) {
        Advancement advancement;
        ServerPlayer player = (ServerPlayer)event.getEntity();
        MinecraftServer server = player.m_20194_();
        PlayerAdvancements playerAdvancements = player.m_8960_();
        if (server != null && (advancement = server.m_129889_().m_136041_(new ResourceLocation("mastersword", "masterswordmain"))) != null && !playerAdvancements.m_135996_(advancement).m_8193_()) {
            playerAdvancements.m_135988_(advancement, "requirement");
        }
    }

    @SubscribeEvent
    public static void swordShrineBreak(BlockEvent.BreakEvent event) {
        SwordShrineBlockEntity swordShrine;
        ItemStack weapon;
        Level level = (Level)event.getLevel();
        BlockPos pos = event.getPos();
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!level.m_5776_() && blockEntity instanceof SwordShrineBlockEntity && !(weapon = (swordShrine = (SwordShrineBlockEntity)blockEntity).getWeapon()).m_41619_()) {
            level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, weapon));
            swordShrine.setWeapon(ItemStack.f_41583_);
        }
    }

    @SubscribeEvent
    public static void rupeePickupSound(PlayerEvent.ItemPickupEvent event) {
        Item pickedUpItem = event.getStack().m_41720_();
        Player player = event.getEntity();
        if (pickedUpItem instanceof GreenRupeeItem || pickedUpItem instanceof BlueRupeeItem || pickedUpItem instanceof RedRupeeItem || pickedUpItem instanceof PurpleRupeeItem || pickedUpItem instanceof SilverRupeeItem || pickedUpItem instanceof GoldRupeeItem) {
            ModMessages.sendToPlayer(new RupeePickupSoundEventS2CPacket(player.m_19879_()), (ServerPlayer)player);
        }
    }

    @SubscribeEvent
    public static void entityDeathDropItems(LivingDeathEvent event) {
        Entity source = event.getSource().m_7639_();
        LivingEntity target = event.getEntity();
        float greenRupeeDropChance = (float)((Integer)MasterSwordCommonConfigs.GREEN_RUPEE_DROP_CHANCE.get()).intValue() / 100.0f;
        float blueRupeeDropChance = (float)((Integer)MasterSwordCommonConfigs.BLUE_RUPEE_DROP_CHANCE.get()).intValue() / 100.0f;
        float redRupeeDropChance = (float)((Integer)MasterSwordCommonConfigs.RED_RUPEE_DROP_CHANCE.get()).intValue() / 100.0f;
        float purpleRupeeDropChance = (float)((Integer)MasterSwordCommonConfigs.PURPLE_RUPEE_DROP_CHANCE.get()).intValue() / 100.0f;
        float silverRupeeDropChance = (float)((Integer)MasterSwordCommonConfigs.SILVER_RUPEE_DROP_CHANCE.get()).intValue() / 100.0f;
        float goldRupeeDropChance = (float)((Integer)MasterSwordCommonConfigs.GOLD_RUPEE_DROP_CHANCE.get()).intValue() / 100.0f;
        if (target.m_6095_().m_20674_() == MobCategory.MONSTER && source instanceof Player) {
            Player player = (Player)source;
            if (!(target instanceof Silverfish) && player instanceof ServerPlayer) {
                CompoundTag persistTag;
                CompoundTag tag;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                float randomValue = player.f_19853_.f_46441_.m_188501_();
                if (greenRupeeDropChance != 0.0f && randomValue < greenRupeeDropChance) {
                    rupee = new ItemEntity(player.f_19853_, target.m_20185_(), target.m_20186_(), target.m_20189_(), new ItemStack((ItemLike)ModItems.GREEN_RUPEE.get()));
                    player.f_19853_.m_7967_((Entity)rupee);
                } else if (blueRupeeDropChance != 0.0f && randomValue < blueRupeeDropChance) {
                    rupee = new ItemEntity(player.f_19853_, target.m_20185_(), target.m_20186_(), target.m_20189_(), new ItemStack((ItemLike)ModItems.BLUE_RUPEE.get()));
                    player.f_19853_.m_7967_((Entity)rupee);
                } else if (redRupeeDropChance != 0.0f && randomValue < redRupeeDropChance) {
                    rupee = new ItemEntity(player.f_19853_, target.m_20185_(), target.m_20186_(), target.m_20189_(), new ItemStack((ItemLike)ModItems.RED_RUPEE.get()));
                    player.f_19853_.m_7967_((Entity)rupee);
                } else if (purpleRupeeDropChance != 0.0f && randomValue < purpleRupeeDropChance) {
                    rupee = new ItemEntity(player.f_19853_, target.m_20185_(), target.m_20186_(), target.m_20189_(), new ItemStack((ItemLike)ModItems.PURPLE_RUPEE.get()));
                    player.f_19853_.m_7967_((Entity)rupee);
                } else if (silverRupeeDropChance != 0.0f && randomValue < silverRupeeDropChance) {
                    rupee = new ItemEntity(player.f_19853_, target.m_20185_(), target.m_20186_(), target.m_20189_(), new ItemStack((ItemLike)ModItems.SILVER_RUPEE.get()));
                    player.f_19853_.m_7967_((Entity)rupee);
                } else if (goldRupeeDropChance != 0.0f && randomValue < goldRupeeDropChance) {
                    rupee = new ItemEntity(player.f_19853_, target.m_20185_(), target.m_20186_(), target.m_20189_(), new ItemStack((ItemLike)ModItems.GOLD_RUPEE.get()));
                    player.f_19853_.m_7967_((Entity)rupee);
                }
                if (player.f_19853_.f_46441_.m_188501_() < 0.15f && MagicMeterData.getMagicAmount((Player)serverPlayer) < MagicMeterData.getMaxMagic((Player)serverPlayer)) {
                    MagicJarPickupItemEntity magicJarItemEntity = new MagicJarPickupItemEntity(player.f_19853_, target.m_20185_(), target.m_20186_(), target.m_20189_(), new ItemStack((ItemLike)ModItems.MAGIC_JAR.get()));
                    player.f_19853_.m_7967_((Entity)magicJarItemEntity);
                }
                if (!(tag = serverPlayer.getPersistentData()).m_128441_("PlayerPersisted")) {
                    tag.m_128365_("PlayerPersisted", (Tag)new CompoundTag());
                }
                if (!(persistTag = tag.m_128469_("PlayerPersisted")).m_128441_("hasUnlockedSong3") && player.f_19853_.f_46441_.m_188501_() < 0.005f) {
                    ItemEntity itemEntity = new ItemEntity(player.f_19853_, target.m_20185_(), target.m_20186_(), target.m_20189_(), new ItemStack((ItemLike)ModItems.SHEET_MUSIC_ZELDAS_LULLABY.get()));
                    player.f_19853_.m_7967_((Entity)itemEntity);
                }
            }
        }
    }
}

