/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.fluid.custom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.mezimaru.mastersword.entity.ModEntities;
import net.mezimaru.mastersword.entity.custom.GreatFairyEntity;
import net.mezimaru.mastersword.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class FairyWaterLiquidBlock
extends LiquidBlock {
    private static final Map<UUID, List<ItemEntity>> thrownItemsPerPlayer = new HashMap<UUID, List<ItemEntity>>();

    public FairyWaterLiquidBlock(Supplier<? extends FlowingFluid> pFluid, BlockBehaviour.Properties pProperties) {
        super(pFluid, pProperties);
    }

    private Set<Item> getUpgradeableItems() {
        HashSet<Item> upgradeableItems = new HashSet<Item>();
        upgradeableItems.add((Item)ModItems.OLD_RUSTY_SHIELD.get());
        upgradeableItems.add((Item)ModItems.BOOMERANG.get());
        upgradeableItems.add((Item)ModItems.MAGIC_LANTERN.get());
        upgradeableItems.add((Item)ModItems.HYLIAN_BOTTLE.get());
        return upgradeableItems;
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return 8;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    private boolean areNearbyFairies(ServerLevel level, BlockPos pos) {
        int searchRadius = 10;
        List fairies = level.m_6443_(GreatFairyEntity.class, new AABB(pos).m_82400_((double)searchRadius), entity -> true);
        return !fairies.isEmpty();
    }

    private void spawnFairy(ServerLevel level, BlockPos startPos) {
        Set<BlockPos> connectedWaterBlocks = this.findConnectedFairyWaterBlocks(level, startPos);
        if (!connectedWaterBlocks.isEmpty()) {
            BlockPos centerPos = this.calculateCenterPosition(connectedWaterBlocks);
            int highestY = this.calculateHighestYPosition(connectedWaterBlocks);
            BlockPos pos = new BlockPos(centerPos.m_123341_(), highestY + 1, centerPos.m_123343_());
            GreatFairyEntity greatFairy = new GreatFairyEntity((EntityType<? extends PathfinderMob>)((EntityType)ModEntities.GREAT_FAIRY.get()), (Level)level);
            greatFairy.setThrownItems(thrownItemsPerPlayer);
            greatFairy.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_() + 1, (double)pos.m_123343_() + 0.5);
            level.m_7967_((Entity)greatFairy);
        }
    }

    private void returnItemToPlayer(ItemEntity itemEntity) {
        UUID playerUUID;
        ServerLevel level;
        Player player;
        CompoundTag nbt = itemEntity.m_32055_().m_41783_();
        if (nbt != null && nbt.m_128441_("TosserUUID") && (player = (level = (ServerLevel)itemEntity.f_19853_).m_46003_(playerUUID = UUID.fromString(nbt.m_128461_("TosserUUID")))) != null) {
            if (!nbt.m_128471_("ReturnedByFairyWater")) {
                Vec3 lookVec = player.m_20154_();
                Vec3 spawnPos = player.m_146892_().m_82549_(lookVec.m_82490_(1.5));
                ItemEntity newItemEntity = new ItemEntity((Level)level, spawnPos.f_82479_, spawnPos.f_82480_ - 0.3, spawnPos.f_82481_, itemEntity.m_32055_().m_41777_());
                newItemEntity.m_20334_(0.0, 0.2, 0.0);
                nbt.m_128379_("ReturnedByFairyWater", true);
                itemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
                level.m_7967_((Entity)newItemEntity);
            } else {
                itemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        super.m_7892_(pState, pLevel, pPos, pEntity);
        if (pLevel instanceof ServerLevel) {
            ItemEntity itemEntity;
            ItemStack stack;
            CompoundTag nbt;
            ServerLevel serverLevel = (ServerLevel)pLevel;
            if (pEntity instanceof ItemEntity && (nbt = (stack = (itemEntity = (ItemEntity)pEntity).m_32055_()).m_41783_()) != null && !nbt.m_128471_("ProcessedByFairyWater") && nbt.m_128441_("TosserUUID")) {
                UUID playerUUID = UUID.fromString(nbt.m_128461_("TosserUUID"));
                Set<Item> upgradeableItems = this.getUpgradeableItems();
                if (upgradeableItems.contains(stack.m_41720_())) {
                    thrownItemsPerPlayer.computeIfAbsent(playerUUID, k -> new ArrayList()).add(itemEntity);
                    nbt.m_128379_("ProcessedByFairyWater", true);
                    if (!this.areNearbyFairies(serverLevel, pPos)) {
                        this.spawnFairy(serverLevel, pPos);
                    }
                    itemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
                } else {
                    this.returnItemToPlayer(itemEntity);
                }
            }
        }
    }

    private AABB getBoundingBox(BlockPos pos) {
        return new AABB(pos).m_82400_(0.5);
    }

    private BlockPos calculateCenterPosition(Set<BlockPos> positions) {
        int sumX = 0;
        int sumZ = 0;
        int count = positions.size();
        for (BlockPos pos : positions) {
            sumX += pos.m_123341_();
            sumZ += pos.m_123343_();
        }
        int centerX = sumX / count;
        int centerZ = sumZ / count;
        return new BlockPos(centerX, 0, centerZ);
    }

    private Set<BlockPos> findConnectedFairyWaterBlocks(ServerLevel level, BlockPos startPos) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        queue.add(startPos);
        while (!queue.isEmpty()) {
            BlockPos current = (BlockPos)queue.poll();
            if (visited.contains(current) || !(level.m_8055_(current).m_60734_() instanceof FairyWaterLiquidBlock)) continue;
            visited.add(current);
            for (Direction direction : new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST}) {
                BlockPos neighbor = current.m_121945_(direction);
                queue.add(neighbor);
            }
        }
        return visited;
    }

    private int calculateHighestYPosition(Set<BlockPos> positions) {
        int highestY = Integer.MIN_VALUE;
        for (BlockPos pos : positions) {
            if (pos.m_123342_() <= highestY) continue;
            highestY = pos.m_123342_();
        }
        return highestY;
    }
}

