/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.item.custom;

import java.util.List;
import java.util.UUID;
import net.mezimaru.mastersword.entity.custom.HookshotHookProjectileEntity;
import net.mezimaru.mastersword.item.ModItems;
import net.mezimaru.mastersword.network.ModMessages;
import net.mezimaru.mastersword.network.packet.HookshotOwnerS2CPacket;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class HookshotItem
extends Item {
    private static final int RESET_TIME_TICKS = 200;
    private int hookTimer = 0;

    public HookshotItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public boolean m_8120_(ItemStack pStack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.BLOCK;
    }

    public int m_8105_(ItemStack pStack) {
        return 4;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player player, InteractionHand pHand) {
        if (!pLevel.f_46443_) {
            ItemStack itemstack = player.m_21120_(pHand);
            if (player.m_21120_(InteractionHand.MAIN_HAND).m_41784_().m_128471_("ShotHook") || player.m_21120_(InteractionHand.OFF_HAND).m_41784_().m_128471_("ShotHook")) {
                return InteractionResultHolder.m_19100_((Object)itemstack);
            }
            UUID playerUUID = player.m_20148_();
            HookshotHookProjectileEntity projectile = new HookshotHookProjectileEntity((LivingEntity)player, pLevel);
            Vec3 handPos = projectile.getHookshotHoldPosition(1.0f, player, pHand);
            projectile.m_5602_((Entity)player);
            projectile.m_6034_(handPos.f_82479_, player.m_20188_() - 0.5, handPos.f_82481_);
            if (itemstack.m_150930_((Item)ModItems.HOOKSHOT.get())) {
                projectile.setProperties(itemstack, 15.0, 10.0, player.m_146909_(), player.m_146908_(), 0.0f, 1.5f);
            } else if (itemstack.m_150930_((Item)ModItems.LONGSHOT.get())) {
                projectile.setProperties(itemstack, 30.0, 10.0, player.m_146909_(), player.m_146908_(), 0.0f, 1.5f);
            }
            player.m_6672_(pHand);
            pLevel.m_7967_((Entity)projectile);
            player.m_36335_().m_41524_((Item)this, 50);
            player.m_21120_(pHand).m_41784_().m_128379_("ShotHook", true);
            ModMessages.sendToNearbyClients(new HookshotOwnerS2CPacket(projectile.m_19879_(), playerUUID, pHand, player.m_146909_()), (ServerPlayer)player);
            ModMessages.sendToPlayer(new HookshotOwnerS2CPacket(projectile.m_19879_(), playerUUID, pHand, player.m_146909_()), (ServerPlayer)player);
        }
        pLevel.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11847_, SoundSource.PLAYERS, 1.0f, -4.0f / (pLevel.m_213780_().m_188501_() * 0.4f + 0.8f));
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        return InteractionResultHolder.m_19096_((Object)player.m_21120_(pHand));
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        super.m_6883_(pStack, pLevel, pEntity, pSlotId, pIsSelected);
        if (pEntity instanceof Player) {
            this.hookTimer = pStack.m_41784_().m_128471_("ShotHook") ? ++this.hookTimer : 0;
            if (this.hookTimer >= 200) {
                pStack.m_41784_().m_128379_("ShotHook", false);
                this.hookTimer = 0;
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public MutableComponent getName(ItemStack stack) {
        MutableComponent itemName = (MutableComponent)super.m_7626_(stack);
        if (stack.m_150930_((Item)ModItems.HOOKSHOT.get())) {
            return itemName.m_130940_(ChatFormatting.BLUE);
        }
        if (stack.m_150930_((Item)ModItems.LONGSHOT.get())) {
            return itemName.m_130940_(ChatFormatting.LIGHT_PURPLE);
        }
        return itemName;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237113_((String)""));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.mastersword.hookshot.tooltip1").m_130940_(ChatFormatting.ITALIC));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.mastersword.hookshot.tooltip2").m_130940_(ChatFormatting.ITALIC));
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }
}

