/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.network.packet;

import java.util.function.Supplier;
import net.mezimaru.mastersword.entity.custom.SwordBeamProjectileEntity;
import net.mezimaru.mastersword.item.custom.CustomSwordItem;
import net.mezimaru.mastersword.item.custom.FierceDeitySwordItem;
import net.mezimaru.mastersword.item.custom.GoldenMasterSwordItem;
import net.mezimaru.mastersword.item.custom.TrueMasterSwordItem;
import net.mezimaru.mastersword.sound.ModSounds;
import net.mezimaru.mastersword.util.AbilityCapability;
import net.mezimaru.mastersword.util.AbilityCapabilityProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class ShootSwordBeamC2SPacket {
    public ShootSwordBeamC2SPacket() {
    }

    public ShootSwordBeamC2SPacket(FriendlyByteBuf buf) {
    }

    private static void shootSwordBeam(Player player, Level level) {
        CompoundTag persistTag;
        SwordBeamProjectileEntity swordBeam = new SwordBeamProjectileEntity((LivingEntity)player, level);
        CompoundTag tag = player.getPersistentData();
        if (!tag.m_128441_("PlayerPersisted")) {
            tag.m_128365_("PlayerPersisted", (Tag)new CompoundTag());
        }
        if ((persistTag = tag.m_128469_("PlayerPersisted")).m_128471_("hasPetFairy") && (persistTag.m_128461_("fairyType").equals("ciela") || persistTag.m_128461_("fairyType").equals("golden"))) {
            level.m_6269_(null, (Entity)player, (SoundEvent)ModSounds.BEAM_SLASH.get(), SoundSource.PLAYERS, 8.0f, 1.0f);
            level.m_6269_(null, (Entity)player, (SoundEvent)ModSounds.SWORD_BEAM2.get(), SoundSource.PLAYERS, 0.6f, 1.0f);
            swordBeam.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 2.0f, 1.0f);
        } else {
            level.m_6269_(null, (Entity)player, (SoundEvent)ModSounds.BEAM_SLASH.get(), SoundSource.PLAYERS, 0.7f, 1.0f);
            level.m_6269_(null, (Entity)player, (SoundEvent)ModSounds.SWORD_BEAM1.get(), SoundSource.PLAYERS, 0.5f, 1.0f);
            swordBeam.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.5f, 1.0f);
        }
        level.m_7967_((Entity)swordBeam);
    }

    private static void handleSwordBeam(ServerPlayer player) {
        ItemStack itemStack;
        Item item;
        if (player.m_21223_() == player.m_21233_() && (item = (itemStack = player.m_21120_(InteractionHand.MAIN_HAND)).m_41720_()) instanceof CustomSwordItem) {
            CustomSwordItem sword = (CustomSwordItem)item;
            AbilityCapability abilityCapability = (AbilityCapability)player.getCapability(AbilityCapabilityProvider.ABILITY_CAPABILITY).orElse(null);
            if (abilityCapability == null) {
                return;
            }
            if (!abilityCapability.isSwordBeamOnCooldown()) {
                ShootSwordBeamC2SPacket.shootSwordBeam((Player)player, player.f_19853_);
                int cooldown = ShootSwordBeamC2SPacket.getCooldownForSword(sword);
                abilityCapability.setSwordBeamCooldownTicks(cooldown);
            }
        }
    }

    private static int getCooldownForSword(CustomSwordItem sword) {
        if (sword instanceof GoldenMasterSwordItem || sword instanceof TrueMasterSwordItem) {
            return 140;
        }
        if (sword instanceof FierceDeitySwordItem) {
            return 176;
        }
        return 148;
    }

    public void toBytes(FriendlyByteBuf buf) {
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                ShootSwordBeamC2SPacket.handleSwordBeam(player);
            }
        });
        context.setPacketHandled(true);
    }
}

