/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.particle.custom;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.mezimaru.mastersword.particle.ModParticles;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.ForgeRegistries;

public class ColoredParticleType
extends ParticleType<ColoredParticleData> {
    public ColoredParticleType() {
        super(false, ColoredParticleData.DESERIALIZER);
    }

    public Codec<ColoredParticleData> m_7652_() {
        return ColoredParticleData.CODEC;
    }

    public static class ColoredParticleData
    implements ParticleOptions {
        public static final Codec<ColoredParticleData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("red").forGetter(d -> Float.valueOf(d.red)), (App)Codec.FLOAT.fieldOf("green").forGetter(d -> Float.valueOf(d.green)), (App)Codec.FLOAT.fieldOf("blue").forGetter(d -> Float.valueOf(d.blue))).apply((Applicative)instance, ColoredParticleData::new));
        public static final ParticleOptions.Deserializer<ColoredParticleData> DESERIALIZER = new ParticleOptions.Deserializer<ColoredParticleData>(){

            public ColoredParticleData fromCommand(ParticleType<ColoredParticleData> type, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                float red = reader.readFloat();
                reader.expect(' ');
                float green = reader.readFloat();
                reader.expect(' ');
                float blue = reader.readFloat();
                return new ColoredParticleData(red, green, blue);
            }

            public ColoredParticleData fromNetwork(ParticleType<ColoredParticleData> type, FriendlyByteBuf buffer) {
                return new ColoredParticleData(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
            }
        };
        private final float red;
        private final float green;
        private final float blue;

        public ColoredParticleData(float red, float green, float blue) {
            this.red = red;
            this.green = green;
            this.blue = blue;
        }

        public ParticleType<?> m_6012_() {
            return (ParticleType)ModParticles.FAIRY_PARTICLES.get();
        }

        public void m_7711_(FriendlyByteBuf buffer) {
            buffer.writeFloat(this.red);
            buffer.writeFloat(this.green);
            buffer.writeFloat(this.blue);
        }

        public String m_5942_() {
            return String.format(Locale.ROOT, "%s %.2f %.2f %.2f", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue));
        }

        public float getRed() {
            return this.red;
        }

        public float getGreen() {
            return this.green;
        }

        public float getBlue() {
            return this.blue;
        }
    }
}

