/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import net.mezimaru.mastersword.structures.Structures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class LandStructures
extends Structure {
    public static final Codec<LandStructures> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LandStructures.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter)).apply((Applicative)instance, LandStructures::new)).codec();
    private static final Block[] FOUNDATION_BLOCKS = new Block[]{Blocks.f_50652_, Blocks.f_50069_, Blocks.f_50334_, Blocks.f_50493_};
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int size;
    private final HeightProvider startHeight;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;

    public LandStructures(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
    }

    private static boolean extraSpawningChecks(Structure.GenerationContext context) {
        ChunkPos chunkpos = context.f_226628_();
        return context.f_226622_().m_223235_(chunkpos.m_45604_(), chunkpos.m_45605_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_()) < 250;
    }

    private static boolean isTerrainFlat(Structure.GenerationContext context, int structureWidth, int structureLength) {
        ChunkPos chunkPos = context.f_226628_();
        int centerX = chunkPos.m_45604_();
        int centerZ = chunkPos.m_45605_();
        int offsetX = structureWidth / 2;
        int offsetZ = structureLength / 2;
        ArrayList<Integer> heights = new ArrayList<Integer>();
        heights.add(LandStructures.getHeightAt(context, centerX - offsetX, centerZ - offsetZ));
        heights.add(LandStructures.getHeightAt(context, centerX + offsetX, centerZ - offsetZ));
        heights.add(LandStructures.getHeightAt(context, centerX - offsetX, centerZ + offsetZ));
        heights.add(LandStructures.getHeightAt(context, centerX + offsetX, centerZ + offsetZ));
        int minHeight = (Integer)Collections.min(heights);
        int maxHeight = (Integer)Collections.max(heights);
        return maxHeight - minHeight <= 4;
    }

    private static int getHeightAt(Structure.GenerationContext context, int x, int z) {
        return context.f_226622_().m_223235_(x, z, Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_());
    }

    protected Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        int structureLength;
        if (!LandStructures.extraSpawningChecks(context)) {
            return Optional.empty();
        }
        Optional structurePiecesGenerator = JigsawPlacement.m_227238_((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)this.size, (BlockPos)new BlockPos(context.f_226628_().m_45604_(), 0, context.f_226628_().m_45605_()), (boolean)false, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter);
        if (!structurePiecesGenerator.isPresent()) {
            return Optional.empty();
        }
        BoundingBox boundingBox = ((Structure.GenerationStub)structurePiecesGenerator.get()).m_226677_().m_192798_();
        int structureWidth = boundingBox.m_162399_() - boundingBox.m_162395_() + 1;
        if (!LandStructures.isTerrainFlat(context, structureWidth, structureLength = boundingBox.m_162401_() - boundingBox.m_162398_() + 1)) {
            return Optional.empty();
        }
        int startY = this.startHeight.m_213859_((RandomSource)context.f_226626_(), new WorldGenerationContext(context.f_226622_(), context.f_226629_()));
        ChunkPos chunkPos = context.f_226628_();
        BlockPos blockPos = new BlockPos(chunkPos.m_45604_(), startY, chunkPos.m_45605_());
        return JigsawPlacement.m_227238_((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)this.size, (BlockPos)blockPos, (boolean)false, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter);
    }

    public StructureType<?> m_213658_() {
        return (StructureType)Structures.LAND_STRUCTURES.get();
    }
}

