/*
 * Decompiled with CFR 0.152.
 */
package com.silas.createwirelessterminal.block.blockentity;

import com.mojang.datafixers.util.Pair;
import com.silas.createwirelessterminal.block.blockentity.CWTBlockEntity;
import com.silas.createwirelessterminal.block.blockentity.InternalInvManipulationBehaviour;
import com.silas.createwirelessterminal.component.CWTDataComponents;
import com.silas.createwirelessterminal.item.CWTItems;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.packager.IdentifiedInventory;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.simibubi.create.content.logistics.packager.PackagerBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class WirelessPackagerBlockEntity
extends PackagerBlockEntity {
    private ItemStackHandler internalInventory;
    public String previouslyUsedAddress = "";
    private UUID playerUUID;
    public static final int CYCLE = 20;
    private Queue<Pair<List<ItemStack>, String>> requestQueue = new LinkedList<Pair<List<ItemStack>, String>>();

    public boolean setPlayer(Player player) {
        Player oldPlayer;
        if (this.level.isClientSide || player == null) {
            return false;
        }
        Player player2 = oldPlayer = this.playerUUID == null ? null : this.level.getPlayerByUUID(this.playerUUID);
        if (oldPlayer == null) {
            this.playerUUID = player.getUUID();
            return true;
        }
        if (!oldPlayer.getInventory().contains(itemStack -> {
            boolean a = itemStack.is(CWTItems.WIRELESS_PACKAGER_TERMINAL);
            BlockPos c = (BlockPos)itemStack.get(CWTDataComponents.LINKED_PACKAGER);
            if (c == null) {
                return false;
            }
            boolean b = 0 == this.worldPosition.compareTo((Vec3i)c);
            return a && b;
        })) {
            this.playerUUID = player.getUUID();
            return true;
        }
        return false;
    }

    public void resetPlayer(Player player) {
        if (this.playerUUID == player.getUUID()) {
            this.playerUUID = null;
        }
    }

    public UUID getPlayer() {
        return this.playerUUID;
    }

    public WirelessPackagerBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)CWTBlockEntity.WIRELESS_PACKAGER_BE.get(), (be, context) -> be.inventory);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        behaviours.removeFirst();
        this.internalInventory = new ItemStackHandler(27);
        this.targetInventory = new InternalInvManipulationBehaviour((SmartBlockEntity)this, (IItemHandler)this.internalInventory);
        behaviours.addFirst((BlockEntityBehaviour)this.targetInventory);
    }

    public void recheckIfLinksPresent() {
    }

    public boolean redstoneModeActive() {
        return true;
    }

    private void submitNewArrivals(InventorySummary before, InventorySummary after) {
    }

    public void activate() {
    }

    public void tick() {
        super.tick();
        this.trySendPackage();
        if (!this.heldBox.isEmpty() && this.animationTicks <= 0) {
            this.wakeTheFrogs();
        }
    }

    public boolean unwrapBox(ItemStack box, boolean simulate) {
        if (this.animationTicks > 0) {
            return false;
        }
        Objects.requireNonNull(this.level);
        ItemStackHandler contents = PackageItem.getContents((ItemStack)box);
        List items = ItemHelper.getNonEmptyStacks((ItemStackHandler)contents);
        if (this.level.isClientSide()) {
            return true;
        }
        Player player = this.level.getPlayerByUUID(this.playerUUID);
        if (player == null) {
            return false;
        }
        if (!simulate) {
            WirelessPackagerBlockEntity.givePlayerItems(items, player, this.level);
            this.previouslyUnwrapped = box;
            this.animationInward = true;
            this.animationTicks = 20;
            this.notifyUpdate();
        }
        return true;
    }

    public static void givePlayerItems(List<ItemStack> stacks, Player player, Level level) {
        for (ItemStack stack : stacks) {
            if (stack.getCount() <= 0) continue;
            boolean flag = player.getInventory().add(stack);
            if (flag && stack.isEmpty()) {
                level.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((player.getRandom().nextFloat() - player.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                player.containerMenu.broadcastChanges();
                continue;
            }
            ItemEntity itementity = player.drop(stack, false);
            if (itementity == null) continue;
            itementity.setNoPickUpDelay();
            itementity.setTarget(player.getUUID());
        }
    }

    protected void updateSignAddress() {
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.level, (BlockPos)this.worldPosition, (IItemHandler)this.internalInventory);
        NonNullList list = NonNullList.create();
        this.requestQueue.forEach(p -> list.addAll((Collection)p.getFirst()));
        ItemHelper.dropContents((Level)this.level, (BlockPos)this.worldPosition, (IItemHandler)new ItemStackHandler(list));
    }

    public void sendPackage(List<ItemStack> stacks, String address) {
        this.previouslyUsedAddress = address;
        this.requestQueue.add((Pair<List<ItemStack>, String>)new Pair(stacks, (Object)address));
    }

    public void trySendPackage() {
        ItemStack stack = ((InvManipulationBehaviour)this.targetInventory.simulate()).extract(ItemHelper.ExtractionCountMode.UPTO, 1);
        if (stack != null && !stack.isEmpty()) {
            this.attemptToSend(null);
            return;
        }
        Pair<List<ItemStack>, String> pair = this.requestQueue.poll();
        if (pair == null) {
            return;
        }
        this.signBasedAddress = (String)pair.getSecond();
        int length = Math.min(((List)pair.getFirst()).size(), 27);
        for (int i = 0; i < length; ++i) {
            this.internalInventory.setStackInSlot(i, (ItemStack)((List)pair.getFirst()).get(i));
        }
        this.attemptToSend(null);
    }

    public boolean isTargetingSameInventory(@Nullable IdentifiedInventory inventory) {
        return false;
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        if (clientPacket) {
            return;
        }
        compound.putString("previouslyUsedAddress", this.previouslyUsedAddress);
        compound.put("InternalInv", (Tag)this.internalInventory.serializeNBT(registries));
        if (this.playerUUID != null) {
            compound.putUUID("LinkedPlayer", this.playerUUID);
        }
        compound.put("RequestQueue", (Tag)this.serializeQueue(registries));
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        if (clientPacket) {
            return;
        }
        this.previouslyUsedAddress = compound.getString("previouslyUsedAddress");
        this.internalInventory.deserializeNBT(registries, (CompoundTag)compound.get("InternalInv"));
        this.playerUUID = compound.getUUID("LinkedPlayer");
        this.deserializeQueue(compound.getList("RequestQueue", 10), registries);
    }

    private ListTag serializeQueue(HolderLookup.Provider registries) {
        ListTag listTag = new ListTag();
        for (Pair pair : this.requestQueue) {
            CompoundTag tag = new CompoundTag();
            tag.putString("Address", (String)pair.getSecond());
            ListTag stackTag = new ListTag();
            for (ItemStack stack : (List)pair.getFirst()) {
                stackTag.add((Object)stack.save(registries));
            }
            tag.put("ItemsToSend", (Tag)stackTag);
        }
        return listTag;
    }

    private void deserializeQueue(ListTag serializedList, HolderLookup.Provider registries) {
        ArrayList<Pair> deserializedQueue = new ArrayList<Pair>();
        for (Tag baseTag : serializedList) {
            if (!(baseTag instanceof CompoundTag)) continue;
            CompoundTag entryTag = (CompoundTag)baseTag;
            String address = entryTag.getString("Address");
            ListTag itemTagList = entryTag.getList("ItemsToSend", 10);
            ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
            for (Tag stackTagBase : itemTagList) {
                CompoundTag stackTag;
                Optional stack;
                if (!(stackTagBase instanceof CompoundTag) || (stack = ItemStack.parse((HolderLookup.Provider)registries, (Tag)(stackTag = (CompoundTag)stackTagBase))).isEmpty()) continue;
                itemStacks.add((ItemStack)stack.get());
            }
            if (itemStacks.isEmpty()) continue;
            deserializedQueue.add(Pair.of(itemStacks, (Object)address));
        }
        this.requestQueue.addAll(deserializedQueue);
    }
}

