/*
 * Decompiled with CFR 0.152.
 */
package com.silas.createwirelessterminal.block.blockentity;

import com.silas.createwirelessterminal.block.blockentity.WirelessPackagerRenderer;
import com.simibubi.create.content.logistics.packager.PackagerBlock;
import com.simibubi.create.content.logistics.packager.PackagerBlockEntity;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.AbstractBlockEntityVisual;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class WirelessPackagerVisual<T extends PackagerBlockEntity>
extends AbstractBlockEntityVisual<T>
implements SimpleDynamicVisual {
    public final TransformedInstance tray;
    public float lastTrayOffset = Float.NaN;
    public PartialModel lastHatchPartial;

    public WirelessPackagerVisual(VisualizationContext ctx, T blockEntity, float partialTick) {
        super(ctx, blockEntity, partialTick);
        this.tray = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)WirelessPackagerRenderer.TRAY)).createInstance();
        Direction facing = ((Direction)this.blockState.getValue((Property)PackagerBlock.FACING)).getOpposite();
        this.animate(partialTick);
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        this.animate(ctx.partialTick());
    }

    public void animate(float partialTick) {
        float trayOffset = ((PackagerBlockEntity)this.blockEntity).getTrayOffset(partialTick);
        if (trayOffset != this.lastTrayOffset) {
            Direction facing = ((Direction)this.blockState.getValue((Property)PackagerBlock.FACING)).getOpposite();
            Vec3 lowerCorner = Vec3.atLowerCornerOf((Vec3i)facing.getNormal());
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)this.tray.setIdentityTransform().translate((Vec3i)this.getVisualPosition())).translate(lowerCorner.scale((double)trayOffset * 0.7))).rotateYCenteredDegrees(facing.toYRot())).setChanged();
            this.lastTrayOffset = trayOffset;
        }
    }

    public void updateLight(float partialTick) {
        this.relight(new FlatLit[]{this.tray});
    }

    protected void _delete() {
        this.tray.delete();
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
    }
}

