/*
 * Decompiled with CFR 0.152.
 */
package com.silas.createwirelessterminal.item.custom;

import com.silas.createwirelessterminal.block.blockentity.WirelessPackagerBlockEntity;
import com.silas.createwirelessterminal.component.CWTDataComponents;
import com.silas.createwirelessterminal.screen.custom.WirelessPackagerTerminalMenu;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class WirelessPackagerTerminal
extends Item {
    public WirelessPackagerTerminal(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        ItemStack stack = context.getItemInHand();
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof WirelessPackagerBlockEntity) {
            WirelessPackagerBlockEntity wpbe = (WirelessPackagerBlockEntity)blockEntity;
            if (player.isShiftKeyDown()) {
                BlockPos oldPos = (BlockPos)stack.get(CWTDataComponents.LINKED_PACKAGER);
                if (wpbe.setPlayer(player)) {
                    BlockEntity blockEntity2;
                    stack.set(CWTDataComponents.LINKED_PACKAGER, (Object)pos);
                    if (oldPos != null && (blockEntity2 = level.getBlockEntity(oldPos)) instanceof WirelessPackagerBlockEntity) {
                        WirelessPackagerBlockEntity oldwpbe = (WirelessPackagerBlockEntity)blockEntity2;
                        oldwpbe.resetPlayer(player);
                    }
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.FAIL;
            }
        }
        this.openMenu(player, stack);
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        if (level.isClientSide) {
            return InteractionResultHolder.success((Object)stack);
        }
        this.openMenu(player, stack);
        return InteractionResultHolder.success((Object)stack);
    }

    private void openMenu(Player player, ItemStack stack) {
        BlockPos pos = (BlockPos)stack.get(CWTDataComponents.LINKED_PACKAGER);
        ClientLevel level = Minecraft.getInstance().level;
        if (pos == null) {
            player.displayClientMessage((Component)new LangBuilder("createwirelessterminal").translate("wirelesspackagerterminal.notconnected", new Object[0]).style(ChatFormatting.RED).component(), true);
            return;
        }
        if (!level.isLoaded(pos)) {
            player.displayClientMessage((Component)new LangBuilder("createwirelessterminal").translate("wirelesspackagerterminal.notloaded", new Object[0]).style(ChatFormatting.RED).component(), false);
            return;
        }
        BlockEntity blockEntity = player.level().getBlockEntity(pos);
        if (blockEntity instanceof WirelessPackagerBlockEntity) {
            WirelessPackagerBlockEntity wpbe = (WirelessPackagerBlockEntity)blockEntity;
            ((ServerPlayer)player).openMenu((MenuProvider)new SimpleMenuProvider((i, inventory, pPlayer) -> WirelessPackagerTerminalMenu.create(i, inventory, stack), (Component)Component.empty()), extraData -> extraData.writeUtf(wpbe.previouslyUsedAddress));
        } else {
            player.displayClientMessage((Component)new LangBuilder("createwirelessterminal").translate("wirelesspackagerterminal.notawirelesspackager", new Object[0]).style(ChatFormatting.RED).component(), true);
        }
    }
}

