/*
 * Decompiled with CFR 0.152.
 */
package com.silas.createwirelessterminal.item.custom;

import com.silas.createwirelessterminal.component.CWTDataComponents;
import com.silas.createwirelessterminal.item.custom.WirelessTerminalData;
import com.silas.createwirelessterminal.networking.TerminalLogisticStockRequestPacket;
import com.silas.createwirelessterminal.screen.custom.WirelessTerminalMenu;
import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.filter.FilterItemStack;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.simibubi.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.createmod.catnip.lang.LangBuilder;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class WirelessTerminalItem
extends Item {
    private static final Map<UUID, WirelessTerminalData> dataStorage = new HashMap<UUID, WirelessTerminalData>();

    public static UUID generateUUID() {
        UUID id;
        while (dataStorage.containsKey(id = UUID.randomUUID())) {
        }
        dataStorage.put(id, new WirelessTerminalData());
        return id;
    }

    public static void onStockPacketReceived(UUID terminal, boolean lastPacket, List<BigItemStack> items) {
        WirelessTerminalData data = WirelessTerminalItem.getInternalData(terminal);
        if (data.newlyReceivedStockSnapshot == null) {
            data.newlyReceivedStockSnapshot = new ArrayList<BigItemStack>();
        }
        data.newlyReceivedStockSnapshot.addAll(items);
        if (!lastPacket) {
            return;
        }
        data.lastClientsideStockSnapshotAsSummary = new InventorySummary();
        data.lastClientsideStockSnapshot = new ArrayList<List<BigItemStack>>();
        for (BigItemStack bigStack : data.newlyReceivedStockSnapshot) {
            data.lastClientsideStockSnapshotAsSummary.add(bigStack);
        }
        if (data.categories != null && !data.categories.isEmpty()) {
            for (ItemStack filter : data.categories) {
                ArrayList<BigItemStack> inCategory = new ArrayList<BigItemStack>();
                if (!filter.isEmpty()) {
                    FilterItemStack filterItemStack = FilterItemStack.of((ItemStack)filter);
                    Iterator<BigItemStack> iterator = data.newlyReceivedStockSnapshot.iterator();
                    while (iterator.hasNext()) {
                        BigItemStack bigStack = iterator.next();
                        if (!filterItemStack.test((Level)Minecraft.getInstance().level, bigStack.stack)) continue;
                        inCategory.add(bigStack);
                        iterator.remove();
                    }
                }
                data.lastClientsideStockSnapshot.add(inCategory);
            }
        }
        ArrayList<BigItemStack> unsorted = new ArrayList<BigItemStack>(data.newlyReceivedStockSnapshot);
        data.lastClientsideStockSnapshot.add(unsorted);
        data.newlyReceivedStockSnapshot = null;
    }

    public static void onCategoryPacketRecived(boolean lastPacket, UUID terminal, List<ItemStack> categories) {
        WirelessTerminalData data = WirelessTerminalItem.getInternalData(terminal);
        if (data.newlyReceivedCategories == null) {
            data.newlyReceivedCategories = new ArrayList<ItemStack>();
        }
        data.newlyReceivedCategories.addAll(categories);
        if (!lastPacket) {
            return;
        }
        data.categories = data.newlyReceivedCategories;
        data.newlyReceivedCategories = null;
        ++data.receivedPackets;
    }

    public static void onHiddenCategoryPacketRecived(boolean lastPacket, UUID terminal, List<Integer> hiddenCategoriesByPlayer) {
        WirelessTerminalData data = WirelessTerminalItem.getInternalData(terminal);
        if (data.newlyReceivedHiddenCategories == null) {
            WirelessTerminalItem.getInternalData((UUID)terminal).newlyReceivedHiddenCategories = new ArrayList<Integer>();
        }
        data.newlyReceivedHiddenCategories.addAll(hiddenCategoriesByPlayer);
        if (!lastPacket) {
            return;
        }
        data.hiddenCategoriesByPlayer = data.newlyReceivedHiddenCategories;
        data.newlyReceivedHiddenCategories = null;
        ++data.receivedPackets;
    }

    public static void onAddressPacketRecived(UUID terminal, String previouslyUsedAddress) {
        WirelessTerminalData data = WirelessTerminalItem.getInternalData(terminal);
        data.previouslyUsedAddress = previouslyUsedAddress;
        ++data.receivedPackets;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (isSelected && stack.getItem() instanceof WirelessTerminalItem && level.isClientSide) {
            WirelessTerminalData data = WirelessTerminalItem.getInternalData(WirelessTerminalItem.getInternalDataUUID(stack));
            if (data.ticksSinceLastUpdate < 100) {
                ++data.ticksSinceLastUpdate;
            }
        }
        super.inventoryTick(stack, level, entity, slotId, isSelected);
    }

    public WirelessTerminalItem(Item.Properties properties) {
        super(properties);
    }

    public static WirelessTerminalData getInternalData(UUID id) {
        if (!dataStorage.containsKey(id)) {
            dataStorage.put(id, new WirelessTerminalData());
        }
        return dataStorage.get(id);
    }

    public static UUID getInternalDataUUID(ItemStack stack) {
        UUID id = (UUID)stack.get(CWTDataComponents.INTERNAL_DATA);
        if (id == null) {
            while (dataStorage.containsKey(id = UUID.randomUUID())) {
            }
            stack.set(CWTDataComponents.INTERNAL_DATA, (Object)id);
        }
        return id;
    }

    public InteractionResult useOn(UseOnContext pContext) {
        BlockEntity be;
        ItemStack stack = pContext.getItemInHand();
        BlockPos pos = pContext.getClickedPos();
        Level level = pContext.getLevel();
        Player player = pContext.getPlayer();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        if (player.isShiftKeyDown() && (be = level.getBlockEntity(pos)) instanceof StockTickerBlockEntity) {
            StockTickerBlockEntity stbe = (StockTickerBlockEntity)be;
            if (level.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            if (stbe.behaviour.mayInteractMessage(player)) {
                stack.set(CWTDataComponents.LINKED_STOCK_TICKER, (Object)pos);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.SUCCESS;
        }
        if (pContext.getHand() != InteractionHand.MAIN_HAND || stack.getItem() instanceof WirelessTerminalItem) {
            // empty if block
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack wti;
        if (usedHand == InteractionHand.MAIN_HAND && (wti = player.getMainHandItem()).getItem() instanceof WirelessTerminalItem) {
            this.openGui(level, player, wti);
        }
        return super.use(level, player, usedHand);
    }

    private void openGui(Level level, Player player, ItemStack stack) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            BlockPos pos = (BlockPos)stack.get(CWTDataComponents.LINKED_STOCK_TICKER);
            if (pos == null) {
                sp.displayClientMessage((Component)new LangBuilder("createwirelessterminal").translate("wirelessterminal.notconnected", new Object[0]).style(ChatFormatting.RED).component(), true);
                return;
            }
            if (!level.isLoaded(pos)) {
                sp.displayClientMessage((Component)new LangBuilder("createwirelessterminal").translate("wirelessterminal.notloaded", new Object[0]).style(ChatFormatting.RED).component(), false);
                return;
            }
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (!(blockEntity instanceof StockTickerBlockEntity)) {
                player.displayClientMessage((Component)new LangBuilder("createwirelessterminal").translate("wirelessterminal.notastocklink", new Object[0]).style(ChatFormatting.RED).component(), true);
                return;
            }
            StockTickerBlockEntity stbe = (StockTickerBlockEntity)blockEntity;
            if (!stbe.behaviour.mayInteract(player)) {
                player.displayClientMessage((Component)CreateLang.translate((String)"stock_keeper.locked", (Object[])new Object[0]).style(ChatFormatting.RED).component(), true);
                return;
            }
            boolean showLockOption = stbe.behaviour.mayAdministrate(player) && Create.LOGISTICS.isLockable(stbe.behaviour.freqId);
            boolean isCurrentlyLocked = Create.LOGISTICS.isLocked(stbe.behaviour.freqId);
            player.openMenu((MenuProvider)new SimpleMenuProvider((i, inventory, pPlayer) -> WirelessTerminalMenu.create(i, inventory, stack), (Component)Component.empty()), buf -> {
                buf.writeBoolean(showLockOption);
                buf.writeBoolean(isCurrentlyLocked);
            });
        }
    }

    public static boolean isTuned(ItemStack stack) {
        return stack.has(CWTDataComponents.LINKED_STOCK_TICKER);
    }

    public static BlockPos getTunedPos(ItemStack stack) {
        return (BlockPos)stack.get(CWTDataComponents.LINKED_STOCK_TICKER);
    }

    public static void refreshClientStockSnapshot(ItemStack stack) {
        WirelessTerminalData data = WirelessTerminalItem.getInternalData(WirelessTerminalItem.getInternalDataUUID(stack));
        data.ticksSinceLastUpdate = 0;
        CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new TerminalLogisticStockRequestPacket(WirelessTerminalItem.getTunedPos(stack), WirelessTerminalItem.getInternalDataUUID(stack)));
    }
}

