/*
 * Decompiled with CFR 0.152.
 */
package com.silas.createwirelessterminal.networking;

import com.silas.createwirelessterminal.item.custom.WirelessTerminalItem;
import com.silas.createwirelessterminal.networking.CWTPackets;
import com.simibubi.create.foundation.utility.AdventureUtil;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.createmod.catnip.net.base.BasePacketPayload;
import net.createmod.catnip.net.base.ClientboundPacketPayload;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public record TerminalAddressResponsePacket(UUID terminal, String previouslyUsedAddress) implements ClientboundPacketPayload
{
    public static final StreamCodec<ByteBuf, TerminalAddressResponsePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, TerminalAddressResponsePacket::terminal, (StreamCodec)ByteBufCodecs.STRING_UTF8, TerminalAddressResponsePacket::previouslyUsedAddress, TerminalAddressResponsePacket::new);

    @OnlyIn(value=Dist.CLIENT)
    public void handle(LocalPlayer player) {
        if (player == null || player.isSpectator() || AdventureUtil.isAdventure((Player)player)) {
            return;
        }
        WirelessTerminalItem.onAddressPacketRecived(this.terminal, this.previouslyUsedAddress);
    }

    public BasePacketPayload.PacketTypeProvider getTypeProvider() {
        return CWTPackets.TERMINAL_ADDRESS_RESPONSE;
    }
}

