/*
 * Decompiled with CFR 0.152.
 */
package com.silas.createwirelessterminal.networking;

import com.silas.createwirelessterminal.networking.CWTPackets;
import com.silas.createwirelessterminal.networking.TerminalAddressResponsePacket;
import com.silas.createwirelessterminal.networking.TerminalCategoriesResponsePacket;
import com.silas.createwirelessterminal.networking.TerminalHiddenCategoriesResponsePacket;
import com.simibubi.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.simibubi.create.foundation.utility.AdventureUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.createmod.catnip.net.base.BasePacketPayload;
import net.createmod.catnip.net.base.ServerboundPacketPayload;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public record TerminalCategoriesRequestPacket(BlockPos pos, UUID terminal) implements ServerboundPacketPayload
{
    public static final StreamCodec<RegistryFriendlyByteBuf, TerminalCategoriesRequestPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, TerminalCategoriesRequestPacket::pos, (StreamCodec)UUIDUtil.STREAM_CODEC, TerminalCategoriesRequestPacket::terminal, TerminalCategoriesRequestPacket::new);

    public void handle(ServerPlayer player) {
        if (player == null || player.isSpectator() || AdventureUtil.isAdventure((Player)player)) {
            return;
        }
        Level world = player.level();
        if (!world.isLoaded(this.pos)) {
            return;
        }
        BlockEntity blockEntity = world.getBlockEntity(this.pos);
        if (blockEntity instanceof StockTickerBlockEntity) {
            StockTickerBlockEntity be = (StockTickerBlockEntity)blockEntity;
            this.divideAndSendToHiddenCategories(player, this.terminal, TerminalCategoriesRequestPacket.getHiddenCategoriesByPlayer(be).getOrDefault(player.getUUID(), List.of()));
            this.divideAndSendToCategories(player, this.terminal, TerminalCategoriesRequestPacket.getCategories(be));
            CatnipServices.NETWORK.sendToClient(player, (CustomPacketPayload)new TerminalAddressResponsePacket(this.terminal, TerminalCategoriesRequestPacket.getPreviouslyUsedAddress(be)));
        }
    }

    public BasePacketPayload.PacketTypeProvider getTypeProvider() {
        return CWTPackets.TERMINAL_CATEGORY_REQUEST;
    }

    public void divideAndSendToCategories(ServerPlayer player, UUID terminal, List<ItemStack> stacks) {
        int remaining = stacks.size();
        ArrayList<ItemStack> currentList = null;
        if (stacks.isEmpty()) {
            CatnipServices.NETWORK.sendToClient(player, (CustomPacketPayload)new TerminalCategoriesResponsePacket(true, terminal, Collections.emptyList()));
        }
        for (ItemStack entry : stacks) {
            if (currentList == null) {
                currentList = new ArrayList<ItemStack>(Math.min(100, remaining));
            }
            currentList.add(entry);
            if (--remaining == 0) break;
            if (currentList.size() < 100) continue;
            CatnipServices.NETWORK.sendToClient(player, (CustomPacketPayload)new TerminalCategoriesResponsePacket(false, terminal, currentList));
            currentList = null;
        }
        if (currentList != null) {
            CatnipServices.NETWORK.sendToClient(player, (CustomPacketPayload)new TerminalCategoriesResponsePacket(true, terminal, (List<ItemStack>)currentList));
        }
    }

    public void divideAndSendToHiddenCategories(ServerPlayer player, UUID terminal, List<Integer> hiddenCategories) {
        int remaining = hiddenCategories.size();
        ArrayList<Integer> currentList = null;
        if (hiddenCategories.isEmpty()) {
            CatnipServices.NETWORK.sendToClient(player, (CustomPacketPayload)new TerminalHiddenCategoriesResponsePacket(true, terminal, Collections.emptyList()));
        }
        for (Integer entry : hiddenCategories) {
            if (currentList == null) {
                currentList = new ArrayList<Integer>(Math.min(100, remaining));
            }
            currentList.add(entry);
            if (--remaining == 0) break;
            if (currentList.size() < 100) continue;
            CatnipServices.NETWORK.sendToClient(player, (CustomPacketPayload)new TerminalHiddenCategoriesResponsePacket(false, terminal, currentList));
            currentList = null;
        }
        if (currentList != null) {
            CatnipServices.NETWORK.sendToClient(player, (CustomPacketPayload)new TerminalHiddenCategoriesResponsePacket(true, terminal, (List<Integer>)currentList));
        }
    }

    public static Map<UUID, List<Integer>> getHiddenCategoriesByPlayer(StockTickerBlockEntity target) {
        try {
            Field field = target.getClass().getDeclaredField("hiddenCategoriesByPlayer");
            field.setAccessible(true);
            return (Map)field.get(target);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<ItemStack> getCategories(StockTickerBlockEntity target) {
        try {
            Field field = target.getClass().getDeclaredField("categories");
            field.setAccessible(true);
            return (List)field.get(target);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getPreviouslyUsedAddress(StockTickerBlockEntity target) {
        try {
            Field field = target.getClass().getDeclaredField("previouslyUsedAddress");
            field.setAccessible(true);
            return (String)field.get(target);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }
}

