/*
 * Decompiled with CFR 0.152.
 */
package com.silas.createwirelessterminal.networking;

import com.silas.createwirelessterminal.networking.CWTPackets;
import com.silas.createwirelessterminal.networking.TerminalLogisticStockResponsePacket;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.simibubi.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.simibubi.create.foundation.utility.AdventureUtil;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.createmod.catnip.net.base.BasePacketPayload;
import net.createmod.catnip.net.base.ServerboundPacketPayload;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public record TerminalLogisticStockRequestPacket(BlockPos pos, UUID terminal) implements ServerboundPacketPayload
{
    public static final StreamCodec<ByteBuf, TerminalLogisticStockRequestPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, TerminalLogisticStockRequestPacket::pos, (StreamCodec)UUIDUtil.STREAM_CODEC, TerminalLogisticStockRequestPacket::terminal, TerminalLogisticStockRequestPacket::new);

    public BasePacketPayload.PacketTypeProvider getTypeProvider() {
        return CWTPackets.ITEM_LOGISTIC_STOCK_REQUEST;
    }

    public void handle(ServerPlayer player) {
        if (player == null || player.isSpectator() || AdventureUtil.isAdventure((Player)player)) {
            return;
        }
        Level world = player.level();
        if (!world.isLoaded(this.pos)) {
            return;
        }
        BlockEntity blockEntity = world.getBlockEntity(this.pos);
        if (blockEntity instanceof StockTickerBlockEntity) {
            StockTickerBlockEntity be = (StockTickerBlockEntity)blockEntity;
            this.divideAndSendTo(player, this.terminal, be.getRecentSummary());
        }
    }

    public void divideAndSendTo(ServerPlayer player, UUID stack, InventorySummary inventorySummary) {
        List stacks = inventorySummary.getStacksByCount();
        int remaining = stacks.size();
        ArrayList<BigItemStack> currentList = null;
        if (stacks.isEmpty()) {
            CatnipServices.NETWORK.sendToClient(player, (CustomPacketPayload)new TerminalLogisticStockResponsePacket(true, this.terminal, Collections.emptyList()));
        }
        for (BigItemStack entry : stacks) {
            if (currentList == null) {
                currentList = new ArrayList<BigItemStack>(Math.min(100, remaining));
            }
            currentList.add(entry);
            if (--remaining == 0) break;
            if (currentList.size() < 100) continue;
            CatnipServices.NETWORK.sendToClient(player, (CustomPacketPayload)new TerminalLogisticStockResponsePacket(false, this.terminal, currentList));
            currentList = null;
        }
        if (currentList != null) {
            CatnipServices.NETWORK.sendToClient(player, (CustomPacketPayload)new TerminalLogisticStockResponsePacket(true, stack, (List<BigItemStack>)currentList));
        }
    }
}

