/*
 * Decompiled with CFR 0.152.
 */
package com.silas.createwirelessterminal.screen.custom;

import com.silas.createwirelessterminal.block.blockentity.WirelessPackagerBlockEntity;
import com.silas.createwirelessterminal.component.CWTDataComponents;
import com.silas.createwirelessterminal.item.custom.WirelessPackagerTerminal;
import com.silas.createwirelessterminal.screen.CWTMenuTypes;
import com.simibubi.create.foundation.gui.menu.MenuBase;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class WirelessPackagerTerminalMenu
extends MenuBase<ItemStack> {
    public Object screenReference;
    protected Container container;
    protected String previouslyUsedAddress;

    public WirelessPackagerTerminalMenu(MenuType<?> type, int id, Inventory inv, RegistryFriendlyByteBuf extraData) {
        super(type, id, inv, extraData);
    }

    public WirelessPackagerTerminalMenu(MenuType<?> type, int id, Inventory inv, ItemStack contentHolder) {
        super(type, id, inv, (Object)contentHolder);
    }

    public WirelessPackagerTerminalMenu(int id, Inventory inv, RegistryFriendlyByteBuf extraData) {
        this((MenuType)CWTMenuTypes.WIRELESS_PACKAGER_TERMINAL_MENU.get(), id, inv, extraData);
    }

    public static AbstractContainerMenu create(int pContainerId, Inventory pPlayerInventory, ItemStack stack) {
        return new WirelessPackagerTerminalMenu((MenuType)CWTMenuTypes.WIRELESS_PACKAGER_TERMINAL_MENU.get(), pContainerId, pPlayerInventory, stack);
    }

    protected ItemStack createOnClient(RegistryFriendlyByteBuf extraData) {
        this.previouslyUsedAddress = extraData.readUtf();
        ItemStack stack = Minecraft.getInstance().player.getMainHandItem();
        if (stack.getItem() instanceof WirelessPackagerTerminal) {
            return stack;
        }
        return null;
    }

    protected void initAndReadInventory(ItemStack contentHolder) {
    }

    public void initializeContents(int pStateId, List<ItemStack> pItems, ItemStack pCarried) {
    }

    protected void addSlots() {
        this.container = new SimpleContainer(27);
        this.addPlayerSlots(20, 154);
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot(this.container, col + row * 9, 24 + col * 20, 24 + row * 20));
            }
        }
    }

    protected void saveData(ItemStack contentHolder) {
        WirelessPackagerBlockEntity.givePlayerItems(((SimpleContainer)this.container).removeAllItems(), this.player, (Level)Minecraft.getInstance().level);
    }

    public void sendItems(String address) {
        Level level;
        BlockEntity be;
        BlockPos pos = (BlockPos)((ItemStack)this.contentHolder).get(CWTDataComponents.LINKED_PACKAGER);
        if (pos != null && (be = (level = this.player.level()).getBlockEntity(pos)) instanceof WirelessPackagerBlockEntity) {
            WirelessPackagerBlockEntity wpbe = (WirelessPackagerBlockEntity)be;
            wpbe.sendPackage(((SimpleContainer)this.container).removeAllItems(), address);
            this.broadcastChanges();
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack sourcestack = slot.getItem();
            itemstack = sourcestack.copy();
            if (index < 36 ? !this.moveItemStackTo(sourcestack, 36, this.slots.size(), false) : !this.moveItemStackTo(sourcestack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
            if (sourcestack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            slot.onTake(player, sourcestack);
        }
        return itemstack;
    }
}

