/*
 * Decompiled with CFR 0.152.
 */
package com.silas.createwirelessterminal.screen.custom;

import com.silas.createwirelessterminal.networking.WirelessPackagerSendBoxPacket;
import com.silas.createwirelessterminal.screen.custom.WirelessPackagerTerminalMenu;
import com.simibubi.create.content.logistics.AddressEditBox;
import com.simibubi.create.content.trains.station.NoShadowFontWrapper;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.widget.IconButton;
import java.util.Collections;
import java.util.List;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class WirelessPackagerTerminalScreen
extends AbstractSimiContainerScreen<WirelessPackagerTerminalMenu> {
    private AddressEditBox addressBox;
    private IconButton sendButton;
    private IconButton acceptPackages;
    private IconButton dontAcceptPackages;
    private List<Rect2i> extraAreas = Collections.emptyList();
    private String previouslyUsedAddress;
    private static final GuiPart BANNER = new GuiPart("stock_keeper", 0, 0, 256, 20);
    private static final GuiPart TOP_ROW = new GuiPart("stock_keeper", 28, 81, 200, 26);
    private static final GuiPart SLOTS_2_3 = new GuiPart("factory_gauge", 98, 46, 60, 40);
    private static final GuiPart LEFT_BOX_END = new GuiPart("factory_gauge", 88, 24, 10, 62);
    private static final GuiPart RIGHT_BOX_END = new GuiPart("factory_gauge", 158, 24, 10, 62);
    private static final GuiPart LEFT_BORDER = new GuiPart("stock_keeper", 24, 81, 4, 34);
    private static final GuiPart RIGHT_BORDER = new GuiPart("stock_keeper", 228, 80, 4, 34);
    private static final GuiPart ADDRESS_AND_SEND = new GuiPart("stock_keeper", 16, 107, 224, 38);
    private static final GuiPart BOTTOM_BORDER = new GuiPart("stock_keeper", 24, 152, 208, 8);

    public WirelessPackagerTerminalScreen(WirelessPackagerTerminalMenu container, Inventory inv, Component title) {
        super((AbstractContainerMenu)container, inv, title);
        this.previouslyUsedAddress = ((WirelessPackagerTerminalMenu)this.menu).previouslyUsedAddress;
    }

    protected void init() {
        this.setWindowSize(224, 244);
        super.init();
        this.clearWidgets();
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        boolean initial = this.addressBox == null;
        this.previouslyUsedAddress = initial ? this.previouslyUsedAddress : this.addressBox.getValue();
        this.addressBox = new AddressEditBox((Screen)this, (Font)new NoShadowFontWrapper(this.font), x + 28, y + 98, 92, 10, false);
        this.addressBox.setTextColor(7424576);
        this.addressBox.setValue(this.previouslyUsedAddress);
        this.addRenderableWidget((GuiEventListener)this.addressBox);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        this.addressBox.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        return true;
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        boolean rmb;
        boolean lmb = pButton == 0;
        boolean bl = rmb = pButton == 1;
        if (this.addressBox.isFocused()) {
            boolean result = this.addressBox.mouseClicked(pMouseX, pMouseY, pButton);
            if (this.addressBox.isHovered() || result) {
                return result;
            }
            this.addressBox.setFocused(false);
        }
        if (lmb && this.isConfirmHovered((int)pMouseX, (int)pMouseY)) {
            this.sendIt();
            this.playUiSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 1.0f, 1.0f);
            return true;
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    private boolean isConfirmHovered(int mouseX, int mouseY) {
        int confirmX = this.getGuiLeft() + 142;
        int confirmY = this.getGuiTop() + 95;
        int confirmW = 78;
        int confirmH = 18;
        if (mouseX < confirmX || mouseX >= confirmX + confirmW) {
            return false;
        }
        return mouseY >= confirmY && mouseY < confirmY + confirmH;
    }

    private void sendIt() {
        CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new WirelessPackagerSendBoxPacket(this.addressBox.getValue()));
    }

    protected void containerTick() {
        super.containerTick();
        this.addressBox.tick();
    }

    protected void renderBg(GuiGraphics graphics, float v, int mouseX, int mouseY) {
        int x = this.getGuiLeft() + 12;
        int y = this.getGuiTop();
        BANNER.render(graphics, x - 28, y);
        TOP_ROW.render(graphics, x, y += 16);
        for (int i = 0; i < 3; ++i) {
            SLOTS_2_3.render(graphics, x + 10 + i * 60, y + 26);
        }
        LEFT_BOX_END.render(graphics, x, y + 4);
        RIGHT_BOX_END.render(graphics, x + 190, y + 4);
        LEFT_BORDER.render(graphics, x - 4, y + 4);
        LEFT_BORDER.render(graphics, x - 4, y + 38);
        RIGHT_BORDER.render(graphics, x + 200, y + 4);
        RIGHT_BORDER.render(graphics, x + 200, y + 38);
        ADDRESS_AND_SEND.render(graphics, x - 12, y + 66);
        BOTTOM_BORDER.render(graphics, x - 4, y + 104);
        this.renderPlayerInventory(graphics, x, y + 120);
    }

    private static class GuiPart {
        public int StartX;
        public int StartY;
        public int Width;
        public int Height;
        ResourceLocation resourceLocation;

        GuiPart(String location, int StartX, int StartY, int Width, int Height) {
            this(ResourceLocation.fromNamespaceAndPath((String)"create", (String)("textures/gui/" + location + ".png")), StartX, StartY, Width, Height);
        }

        GuiPart(ResourceLocation resourceLocation, int StartX, int StartY, int Width, int Height) {
            this.StartX = StartX;
            this.StartY = StartY;
            this.Width = Width;
            this.Height = Height;
            this.resourceLocation = resourceLocation;
        }

        private void render(GuiGraphics graphics, int x, int y) {
            graphics.blit(this.resourceLocation, x, y, this.StartX, this.StartY, this.Width, this.Height);
        }
    }
}

