/*
 * Decompiled with CFR 0.152.
 */
package com.silas.createwirelessterminal.screen.custom;

import com.mojang.blaze3d.vertex.PoseStack;
import com.silas.createwirelessterminal.item.custom.WirelessTerminalItem;
import com.silas.createwirelessterminal.networking.TerminalCategoriesRequestPacket;
import com.silas.createwirelessterminal.screen.custom.WirelessTerminalMenu;
import com.silas.createwirelessterminal.screen.custom.WirelessTerminalScreen;
import java.util.UUID;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class WirelessTerminalLoadingScreen
extends AbstractContainerScreen<WirelessTerminalMenu> {
    private WirelessTerminalMenu menu;
    private Inventory inv;
    private Component title;

    public WirelessTerminalLoadingScreen(WirelessTerminalMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        this.menu = menu;
        this.inv = inv;
        this.title = title;
        ItemStack stack = Minecraft.getInstance().player.getMainHandItem();
        if (stack.getItem() instanceof WirelessTerminalItem) {
            CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new TerminalCategoriesRequestPacket(WirelessTerminalItem.getTunedPos(stack), WirelessTerminalItem.getInternalDataUUID(stack)));
        }
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
    }

    protected void renderBg(GuiGraphics guiGraphics, float v, int i, int i1) {
    }

    protected void containerTick() {
        if (WirelessTerminalItem.getInternalData((UUID)WirelessTerminalItem.getInternalDataUUID((ItemStack)((ItemStack)this.menu.contentHolder))).receivedPackets < 3) {
            return;
        }
        Minecraft.getInstance().setScreen((Screen)new WirelessTerminalScreen(this.menu, this.inv, this.title, true));
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int boxWidth = 140;
        int boxHeight = 50;
        int x = (this.width - boxWidth) / 2;
        int y = (this.height - boxHeight) / 2;
        guiGraphics.fill(x - 1, y - 1, x + boxWidth + 1, y + boxHeight + 1, -1600085761);
        guiGraphics.fill(x, y, x + boxWidth, y + boxHeight, -13948117);
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        float scale = 1.5f;
        poseStack.scale(scale, scale, 1.0f);
        int scaledX = (int)((float)(this.width / 2) / scale);
        int scaledY = (int)((float)(y + boxHeight / 2 - 4) / scale);
        guiGraphics.drawCenteredString(this.font, "Loading...", scaledX, scaledY, 0xFFFFFF);
        poseStack.popPose();
    }
}

