/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.client.model;

import com.teamabnormals.atmospheric.common.entity.Cochineal;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class CochinealModel<T extends Cochineal>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart leftFrontLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftMiddleLeg;
    private final ModelPart rightMiddleLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightHindLeg;

    public CochinealModel(ModelPart root) {
        this.root = root;
        this.body = root.getChild("body");
        this.leftFrontLeg = root.getChild("left_front_leg");
        this.rightFrontLeg = root.getChild("right_front_leg");
        this.leftMiddleLeg = root.getChild("left_middle_leg");
        this.rightMiddleLeg = root.getChild("right_middle_leg");
        this.leftHindLeg = root.getChild("left_hind_leg");
        this.rightHindLeg = root.getChild("right_hind_leg");
    }

    public static LayerDefinition createBodyLayer(CubeDeformation deformation) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partDefinition = meshdefinition.getRoot();
        partDefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, -6.5f, -10.0f, 12.0f, 9.0f, 20.0f, deformation), PartPose.offset((float)0.0f, (float)13.5f, (float)-1.0f));
        CubeListBuilder leftLeg = CubeListBuilder.create().texOffs(-2, 29).addBox(0.0f, 0.0f, -1.0f, 20.0f, 0.0f, 2.0f).texOffs(0, 29).addBox(0.0f, -1.0f, 0.0f, 20.0f, 2.0f, 0.0f);
        CubeListBuilder rightLeg = CubeListBuilder.create().texOffs(-2, 29).mirror().addBox(-20.0f, 0.0f, -1.0f, 20.0f, 0.0f, 2.0f).texOffs(0, 29).mirror().addBox(-20.0f, -1.0f, 0.0f, 20.0f, 2.0f, 0.0f);
        partDefinition.addOrReplaceChild("left_front_leg", leftLeg, PartPose.offset((float)6.0f, (float)15.0f, (float)-5.0f));
        partDefinition.addOrReplaceChild("right_front_leg", rightLeg, PartPose.offset((float)-6.0f, (float)15.0f, (float)-5.0f));
        partDefinition.addOrReplaceChild("left_middle_leg", leftLeg, PartPose.offset((float)6.0f, (float)15.0f, (float)1.0f));
        partDefinition.addOrReplaceChild("right_middle_leg", rightLeg, PartPose.offset((float)-6.0f, (float)15.0f, (float)1.0f));
        partDefinition.addOrReplaceChild("left_hind_leg", leftLeg, PartPose.offset((float)6.0f, (float)15.0f, (float)7.0f));
        partDefinition.addOrReplaceChild("right_hind_leg", rightLeg, PartPose.offset((float)-6.0f, (float)15.0f, (float)7.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(T cochineal, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean sucklingcactus = ((Cochineal)((Object)cochineal)).isAttachedToCactus();
        this.rightHindLeg.visible = !sucklingcactus;
        this.leftHindLeg.visible = !sucklingcactus;
        this.rightMiddleLeg.visible = !sucklingcactus;
        this.leftMiddleLeg.visible = !sucklingcactus;
        this.rightFrontLeg.visible = !sucklingcactus;
        boolean bl = this.leftFrontLeg.visible = !sucklingcactus;
        if (sucklingcactus) {
            this.body.y = 14.0f;
            this.body.z = -4.0f;
            this.body.xRot = -1.5707964f;
        } else {
            float partialtick = ageInTicks - (float)((Cochineal)((Object)cochineal)).tickCount;
            float jumpamount = ((Cochineal)((Object)cochineal)).getJumpAmount(partialtick);
            float noanimamount = 1.0f - jumpamount * 1.75f;
            this.body.y = 13.5f;
            this.body.z = -1.0f;
            this.body.xRot = 0.0f;
            this.rightHindLeg.zRot = -(0.58119464f + jumpamount);
            this.leftHindLeg.zRot = 0.58119464f + jumpamount;
            this.rightMiddleLeg.zRot = -(0.5235988f + jumpamount);
            this.leftMiddleLeg.zRot = 0.5235988f + jumpamount;
            this.rightFrontLeg.zRot = -(0.58119464f + jumpamount);
            this.leftFrontLeg.zRot = 0.58119464f + jumpamount;
            this.rightHindLeg.yRot = 0.5235988f;
            this.leftHindLeg.yRot = -0.5235988f;
            this.rightMiddleLeg.yRot = 0.0f;
            this.leftMiddleLeg.yRot = 0.0f;
            this.rightFrontLeg.yRot = -0.5235988f;
            this.leftFrontLeg.yRot = 0.5235988f;
            float yHind = -(Mth.cos((float)(limbSwing * 0.6662f * 2.0f + 1.5707964f)) * 0.4f) * limbSwingAmount * noanimamount;
            float yMid = -(Mth.cos((float)(limbSwing * 0.6662f * 2.0f)) * 0.4f) * limbSwingAmount * noanimamount;
            float yFront = -(Mth.cos((float)(limbSwing * 0.6662f * 2.0f + 1.5707964f)) * 0.4f) * limbSwingAmount * noanimamount;
            float zHind = Math.abs(Mth.sin((float)(limbSwing * 0.6662f + 1.5707964f)) * 0.4f) * limbSwingAmount * noanimamount;
            float zMid = Math.abs(Mth.sin((float)(limbSwing * 0.6662f)) * 0.4f) * limbSwingAmount * noanimamount;
            float zFront = Math.abs(Mth.sin((float)(limbSwing * 0.6662f + 1.5707964f)) * 0.4f) * limbSwingAmount * noanimamount;
            this.rightHindLeg.yRot += yHind;
            this.leftHindLeg.yRot += -yHind;
            this.rightMiddleLeg.yRot += yMid;
            this.leftMiddleLeg.yRot += -yMid;
            this.rightFrontLeg.yRot += yFront;
            this.leftFrontLeg.yRot += -yFront;
            this.rightHindLeg.zRot += zHind;
            this.leftHindLeg.zRot += -zHind;
            this.rightMiddleLeg.zRot += zMid;
            this.leftMiddleLeg.zRot += -zMid;
            this.rightFrontLeg.zRot += zFront;
            this.leftFrontLeg.zRot += -zFront;
        }
    }
}

