/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teamabnormals.atmospheric.common.entity.projectile.DragonFruit;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class DragonFruitModel<T extends DragonFruit>
extends EntityModel<T> {
    private final ModelPart fruit;

    public DragonFruitModel(ModelPart root) {
        this.fruit = root.getChild("fruit");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("fruit", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -3.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)0.0f, (float)((float)Math.PI), (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)16, (int)16);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float yRot = entity.getYRot();
        this.fruit.xRot = 0.0f;
        this.fruit.zRot = (float)Math.PI;
        this.fruit.yRot = (yRot + 180.0f) * ((float)Math.PI / 180);
        float amount = ageInTicks / 3.0f;
        if (yRot == -90.0f) {
            amount *= -1.0f;
        }
        if (Math.abs(yRot) == 90.0f) {
            this.fruit.zRot += amount;
        } else {
            this.fruit.xRot += amount;
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.fruit.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

