/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.client.model;

import com.teamabnormals.atmospheric.common.entity.Tetra;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;

public class TetraModel<T extends Tetra>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart tail;

    public TetraModel(ModelPart root) {
        super(RenderType::entityTranslucent);
        this.root = root;
        this.tail = root.getChild("tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition part = mesh.getRoot();
        PartDefinition body = part.addOrReplaceChild("body", CubeListBuilder.create().texOffs(2, 1).addBox(-0.5f, -3.0f, -3.0f, 1.0f, 2.0f, 5.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        body.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(9, 12).addBox(-0.5f, -3.0f, -4.0f, 1.0f, 1.0f, 1.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        part.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(3, 10).addBox(0.0f, -1.0f, 0.0f, 0.0f, 2.0f, 2.0f), PartPose.offset((float)0.0f, (float)22.0f, (float)2.0f));
        part.addOrReplaceChild("right_fin", CubeListBuilder.create().texOffs(6, 9).addBox(-1.5f, -1.0f, 1.0f, 1.0f, 0.0f, 2.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        part.addOrReplaceChild("left_fin", CubeListBuilder.create().texOffs(9, 9).addBox(0.5f, -1.0f, 1.0f, 1.0f, 0.0f, 2.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        part.addOrReplaceChild("top_fin", CubeListBuilder.create().texOffs(3, 7).addBox(0.0f, -4.0f, -1.0f, 0.0f, 1.0f, 2.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)16, (int)16);
    }

    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = 1.0f;
        if (!entity.isInWater()) {
            f = 1.5f;
        }
        this.tail.yRot = -f * 0.45f * Mth.sin((float)(0.6f * ageInTicks));
    }
}

