/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AloeBlossomParticle
extends TextureSheetParticle {
    protected final SpriteSet animatedSprite;
    private float angle;

    public AloeBlossomParticle(SpriteSet animatedSprite, ClientLevel world, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
        super(world, posX, posY, posZ, motionX, motionY, motionZ);
        this.xd = motionX;
        this.yd = motionY + this.random.nextDouble() * 0.05;
        this.zd = motionZ;
        this.angle = (float)Math.random() * ((float)Math.PI * 2);
        this.animatedSprite = animatedSprite;
        this.lifetime = this.random.nextInt(75) + 75;
        this.quadSize = 0.2f * (this.random.nextFloat() * 0.5f + 0.5f) * 2.0f;
        this.setSpriteFromAge(animatedSprite);
    }

    public void tick() {
        if (this.age % 5 == 0) {
            this.angle = (float)Math.random() * ((float)Math.PI * 2);
        }
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.yd -= 0.04 * (double)this.gravity;
            this.move(this.xd, this.yd, this.zd);
            this.xd += Math.cos(this.angle) * 5.0E-4;
            this.zd += Math.sin(this.angle) * 5.0E-4;
            this.yd *= 0.98;
        }
        this.alpha -= (float)this.lifetime / 10000.0f;
        this.setSpriteFromAge(this.animatedSprite);
    }

    public int getLightColor(float partialTick) {
        float f = (float)this.lifetime / ((float)this.age + (float)this.lifetime * 0.5f + partialTick);
        f = Mth.clamp((float)f, (float)0.0f, (float)0.5f);
        int i = super.getLightColor(partialTick);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet animatedSprite;

        public Factory(SpriteSet animatedSprite) {
            this.animatedSprite = animatedSprite;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new AloeBlossomParticle(this.animatedSprite, world, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }
}

