/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.teamabnormals.atmospheric.client.model.CochinealModel;
import com.teamabnormals.atmospheric.common.entity.Cochineal;
import com.teamabnormals.atmospheric.core.Atmospheric;
import com.teamabnormals.atmospheric.core.other.AtmosphericModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.SaddleLayer;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CochinealRenderer<T extends Cochineal>
extends MobRenderer<T, CochinealModel<T>> {
    private static final ResourceLocation COCHINEAL_LOCATION = Atmospheric.location("textures/entity/cochineal/cochineal.png");

    public CochinealRenderer(EntityRendererProvider.Context context) {
        super(context, new CochinealModel(context.bakeLayer(AtmosphericModelLayers.COCHINEAL)), 0.6f);
        this.addLayer((RenderLayer)new SaddleLayer((RenderLayerParent)this, new CochinealModel(context.bakeLayer(AtmosphericModelLayers.COCHINEAL_SADDLE)), Atmospheric.location("textures/entity/cochineal/cochineal_saddle.png")));
    }

    protected void scale(T cochineal, PoseStack stack, float partialTicks) {
        if (cochineal.isBaby()) {
            stack.scale(0.4f, 0.4f, 0.4f);
            this.shadowRadius = 0.4f;
        } else {
            this.shadowRadius = 1.0f;
        }
        if (((Cochineal)((Object)cochineal)).isAttachedToCactus()) {
            this.shadowRadius = 0.0f;
        }
    }

    public ResourceLocation getTextureLocation(T cochineal) {
        return COCHINEAL_LOCATION;
    }
}

