/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.teamabnormals.atmospheric.client.model.DragonFruitModel;
import com.teamabnormals.atmospheric.client.renderer.entity.layers.FloweringDragonFruitLayer;
import com.teamabnormals.atmospheric.common.entity.projectile.DragonFruit;
import com.teamabnormals.atmospheric.core.Atmospheric;
import com.teamabnormals.atmospheric.core.other.AtmosphericModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DragonFruitRenderer<T extends DragonFruit>
extends EntityRenderer<T>
implements RenderLayerParent<T, DragonFruitModel<T>> {
    private static final ResourceLocation DRAGON_FRUIT = Atmospheric.location("textures/block/dragon_fruit.png");
    private static final ResourceLocation DRAGON_FRUIT_FLOWERING = Atmospheric.location("textures/block/flowering_dragon_fruit.png");
    private static final ResourceLocation ENDER_DRAGON_FRUIT = Atmospheric.location("textures/block/ender_dragon_fruit.png");
    private static final ResourceLocation ENDER_DRAGON_FRUIT_FLOWERING = Atmospheric.location("textures/block/flowering_ender_dragon_fruit.png");
    private final DragonFruitModel<T> model;
    protected final RenderLayer<T, DragonFruitModel<T>> layer = new FloweringDragonFruitLayer(this);

    public DragonFruitRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new DragonFruitModel(context.bakeLayer(AtmosphericModelLayers.DRAGON_FRUIT));
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - entity.getYRot()));
        this.getModel().setupAnim(entity, partialTicks, 0.0f, (float)((DragonFruit)((Object)entity)).tickCount + partialTicks, 0.0f, 0.0f);
        poseStack.popPose();
        VertexConsumer vertexConsumer = buffer.getBuffer(this.model.renderType(this.getTextureLocation(entity)));
        this.getModel().renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY);
        this.layer.render(poseStack, buffer, packedLight, entity, 0.0f, 0.0f, partialTicks, 0.0f, 0.0f, 0.0f);
        super.render(entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public DragonFruitModel<T> getModel() {
        return this.model;
    }

    public ResourceLocation getTextureLocation(T fruit) {
        return ((DragonFruit)((Object)fruit)).isEnder() ? (((DragonFruit)((Object)fruit)).isFlowering() ? ENDER_DRAGON_FRUIT_FLOWERING : ENDER_DRAGON_FRUIT) : (((DragonFruit)((Object)fruit)).isFlowering() ? DRAGON_FRUIT_FLOWERING : DRAGON_FRUIT);
    }
}

