/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.teamabnormals.atmospheric.client.model.PassionFruitSeedModel;
import com.teamabnormals.atmospheric.common.entity.projectile.PassionFruitSeed;
import com.teamabnormals.atmospheric.core.Atmospheric;
import com.teamabnormals.atmospheric.core.other.AtmosphericModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PassionFruitSeedRenderer
extends EntityRenderer<PassionFruitSeed> {
    private static final ResourceLocation PASSION_FRUIT_SEED_TEXTURE = Atmospheric.location("textures/entity/projectiles/passion_fruit_seed.png");
    private final PassionFruitSeedModel<PassionFruitSeed> model;

    public PassionFruitSeedRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new PassionFruitSeedModel(context.bakeLayer(AtmosphericModelLayers.PASSION_FRUIT_SEED));
    }

    public void render(PassionFruitSeed entityIn, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (entityIn.tickCount >= 2 || !(this.entityRenderDispatcher.camera.getEntity().distanceToSqr((Entity)entityIn) < 9.0)) {
            poseStack.pushPose();
            poseStack.translate(0.0, (double)0.1825f, 0.0);
            poseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entityIn.yRotO, (float)entityIn.getYRot()) - 90.0f));
            poseStack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entityIn.xRotO, (float)entityIn.getXRot())));
            this.model.setupAnim(entityIn, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
            this.model.renderToBuffer(poseStack, buffer.getBuffer(this.model.renderType(PASSION_FRUIT_SEED_TEXTURE)), packedLight, OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
            super.render((Entity)entityIn, entityYaw, partialTicks, poseStack, buffer, packedLight);
        }
    }

    public ResourceLocation getTextureLocation(PassionFruitSeed entity) {
        return PASSION_FRUIT_SEED_TEXTURE;
    }
}

