/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.teamabnormals.atmospheric.client.model.TetraModel;
import com.teamabnormals.atmospheric.common.entity.Tetra;
import com.teamabnormals.atmospheric.common.entity.TetraVariant;
import com.teamabnormals.atmospheric.core.other.AtmosphericModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TetraRenderer
extends MobRenderer<Tetra, TetraModel<Tetra>> {
    public TetraRenderer(EntityRendererProvider.Context context) {
        super(context, new TetraModel(context.bakeLayer(AtmosphericModelLayers.TETRA)), 0.15f);
    }

    public ResourceLocation getTextureLocation(Tetra tetra) {
        return ((TetraVariant)tetra.getVariant().value()).assetId().withPrefix("textures/").withSuffix(".png");
    }

    protected void setupRotations(Tetra tetra, PoseStack poseStack, float bob, float yBodyRot, float partialTick, float scale) {
        super.setupRotations((LivingEntity)tetra, poseStack, bob, yBodyRot, partialTick, scale);
        float f = 4.3f * Mth.sin((float)(0.6f * bob));
        poseStack.mulPose(Axis.YP.rotationDegrees(f));
        if (!tetra.isInWater()) {
            poseStack.translate(0.2f, 0.1f, 0.0f);
            poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
        }
    }

    protected int getBlockLightLevel(Tetra tetra, BlockPos pos) {
        return Mth.clamp((int)(super.getBlockLightLevel((Entity)tetra, pos) + 7), (int)0, (int)15);
    }
}

