/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.block;

import com.teamabnormals.blueprint.core.other.tags.BlueprintBlockTags;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AloeGelBlock
extends HalfTransparentBlock {
    public static final BooleanProperty WET = BooleanProperty.create((String)"wet");

    public AloeGelBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WET, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)WET) != false ? Shapes.block() : Shapes.empty();
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)WET, (Comparable)Boolean.valueOf(this.touchingWater(context.getClickedPos(), (BlockGetter)context.getLevel())));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WET});
    }

    public boolean isStickyBlock(BlockState state) {
        return (Boolean)state.getValue((Property)WET) == false;
    }

    public boolean canStickTo(BlockState state, BlockState other) {
        return (other.is((Block)this) || !other.is(BlueprintBlockTags.ATTACHES_BLOCKS_TO_PISTONS)) && super.canStickTo(state, other);
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return (BlockState)stateIn.setValue((Property)WET, (Comparable)Boolean.valueOf(this.touchingWater(currentPos, (BlockGetter)worldIn)));
    }

    public final boolean touchingWater(BlockPos blockPos, BlockGetter iBlockReader) {
        for (Direction direction : Direction.values()) {
            if (!iBlockReader.getFluidState(blockPos.relative(direction)).is(FluidTags.WATER)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public PathType getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, @Nullable Mob entity) {
        return PathType.DAMAGE_OTHER;
    }

    @Nullable
    public PathType getAdjacentBlockPathType(BlockState state, BlockGetter world, BlockPos pos, @Nullable Mob entity, PathType originalType) {
        return PathType.DANGER_OTHER;
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (!((Boolean)state.getValue((Property)WET)).booleanValue()) {
            entity.makeStuckInBlock(state, new Vec3(0.25, 0.25, 0.25));
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.addEffect(new MobEffectInstance(MobEffects.POISON, 150, 0, false, true, true));
                living.clearFire();
            }
        }
    }
}

