/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.block;

import com.mojang.serialization.MapCodec;
import com.teamabnormals.atmospheric.common.block.AloeVeraTallBlock;
import com.teamabnormals.atmospheric.core.other.tags.AtmosphericBlockTags;
import com.teamabnormals.atmospheric.core.other.tags.AtmosphericEntityTypeTags;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.atmospheric.core.registry.AtmosphericCriteriaTriggers;
import com.teamabnormals.atmospheric.core.registry.AtmosphericItems;
import com.teamabnormals.atmospheric.core.registry.datapack.AtmosphericDamageTypes;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.Tags;

public class AloeVeraBlock
extends BushBlock
implements BonemealableBlock {
    public static final VoxelShape SHAPE_SMALL = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0);
    public static final VoxelShape SHAPE_MEDIUM = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
    public static final VoxelShape SHAPE_LARGE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);
    public static final IntegerProperty AGE = BlockStateProperties.AGE_5;

    public AloeVeraBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<? extends BushBlock> codec() {
        return null;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        int age = (Integer)state.getValue((Property)AGE);
        VoxelShape shape = age >= 4 ? SHAPE_LARGE : (age >= 2 ? SHAPE_MEDIUM : SHAPE_SMALL);
        Vec3 vec3d = state.getOffset(worldIn, pos);
        return shape.move(vec3d.x, vec3d.y, vec3d.z);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is(Items.BONE_MEAL)) {
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        int i = (Integer)state.getValue((Property)AGE);
        if (i == 5 && stack.is(Tags.Items.TOOLS_SHEAR)) {
            RandomSource rand = player.getRandom();
            stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            level.playSound(null, pos, SoundEvents.SHEEP_SHEAR, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
            level.playSound(null, pos, SoundEvents.SLIME_BLOCK_BREAK, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(2)));
            AloeVeraBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)AtmosphericItems.ALOE_LEAVES.get(), rand.nextInt(5) + 3));
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof LivingEntity && !entity.getType().is(AtmosphericEntityTypeTags.ALOE_IMMUNE)) {
            double chance = 0.1f;
            if ((Integer)state.getValue((Property)AGE) == 4) {
                chance = 0.2f;
            }
            if ((Integer)state.getValue((Property)AGE) == 5) {
                chance = 0.4f;
            }
            if (!level.isClientSide && (Integer)state.getValue((Property)AGE) > 2 && Math.random() <= chance) {
                entity.makeStuckInBlock(state, new Vec3((double)0.2f, 0.2, (double)0.2f));
                entity.hurt(AtmosphericDamageTypes.aloeLeaves(level), 1.0f);
                if (entity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    if (!entity.getCommandSenderWorld().isClientSide() && !serverPlayer.isCreative()) {
                        ((PlayerTrigger)AtmosphericCriteriaTriggers.ALOE_VERA_PRICK.get()).trigger(serverPlayer);
                    }
                }
            }
        }
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockState downState = worldIn.getBlockState(pos.below());
        return downState.is(AtmosphericBlockTags.ALOE_PLACEABLE);
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(Level level, RandomSource rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel world, RandomSource rand, BlockPos pos, BlockState state) {
        int age = (Integer)state.getValue((Property)AGE);
        if (age < 5) {
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age + 1)));
        } else if (world.getBlockState(pos.above()).isAir() && world.getBlockState(pos.below()).is(AtmosphericBlockTags.TALL_ALOE_GROWABLE_ON)) {
            this.placeAt((LevelAccessor)world, pos, 2);
        }
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        int chance;
        boolean flag = worldIn.getBlockState(pos.below()).is(AtmosphericBlockTags.TALL_ALOE_GROWABLE_ON);
        int n = chance = flag ? 7 : 5;
        if (worldIn.getRawBrightness(pos.above(), 0) >= 12 && CommonHooks.canCropGrow((Level)worldIn, (BlockPos)pos, (BlockState)state, (random.nextInt(chance) == 0 ? 1 : 0) != 0)) {
            if ((Integer)state.getValue((Property)AGE) < 5) {
                worldIn.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf((Integer)state.getValue((Property)AGE) + 1)));
            } else if (flag && ((Block)AtmosphericBlocks.TALL_ALOE_VERA.get()).defaultBlockState().canSurvive((LevelReader)worldIn, pos) && worldIn.isEmptyBlock(pos.above())) {
                AloeVeraTallBlock.placeAt((LevelAccessor)worldIn, (BlockState)((Block)AtmosphericBlocks.TALL_ALOE_VERA.get()).defaultBlockState(), (BlockPos)pos, (int)2);
            }
            CommonHooks.fireCropGrowPost((Level)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    @Nullable
    public PathType getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, @Nullable Mob entity) {
        return PathType.DAMAGE_OTHER;
    }

    @Nullable
    public PathType getAdjacentBlockPathType(BlockState state, BlockGetter world, BlockPos pos, @Nullable Mob entity, PathType originalType) {
        return PathType.DANGER_OTHER;
    }

    public void placeAt(LevelAccessor world, BlockPos pos, int flags) {
        world.setBlock(pos, (BlockState)((Block)AtmosphericBlocks.TALL_ALOE_VERA.get()).defaultBlockState().setValue((Property)AloeVeraTallBlock.HALF, (Comparable)DoubleBlockHalf.LOWER), flags);
        world.setBlock(pos.above(), (BlockState)((Block)AtmosphericBlocks.TALL_ALOE_VERA.get()).defaultBlockState().setValue((Property)AloeVeraTallBlock.HALF, (Comparable)DoubleBlockHalf.UPPER), flags);
    }
}

