/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.block;

import com.teamabnormals.atmospheric.common.block.AloeVeraBlock;
import com.teamabnormals.atmospheric.core.other.tags.AtmosphericBlockTags;
import com.teamabnormals.atmospheric.core.other.tags.AtmosphericEntityTypeTags;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.atmospheric.core.registry.AtmosphericCriteriaTriggers;
import com.teamabnormals.atmospheric.core.registry.AtmosphericItems;
import com.teamabnormals.atmospheric.core.registry.AtmosphericParticleTypes;
import com.teamabnormals.atmospheric.core.registry.datapack.AtmosphericDamageTypes;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.Tags;

public class AloeVeraTallBlock
extends DoublePlantBlock
implements BonemealableBlock {
    public static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final VoxelShape SHAPE_TOP = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0);
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)6, (int)8);

    public AloeVeraTallBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)AGE, (Comparable)Integer.valueOf(6))).setValue((Property)HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Vec3 vec3d = state.getOffset(level, pos);
        VoxelShape shape = state.getValue((Property)HALF) == DoubleBlockHalf.UPPER ? SHAPE_TOP : SHAPE;
        return shape.move(vec3d.x, vec3d.y, vec3d.z);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HALF, AGE});
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        BlockState downState = level.getBlockState(pos.below());
        if (state.getBlock() instanceof AloeVeraTallBlock) {
            DoubleBlockHalf half = (DoubleBlockHalf)state.getValue((Property)HALF);
            if (half == DoubleBlockHalf.UPPER) {
                return downState.getBlock() instanceof AloeVeraTallBlock;
            }
            return downState.is(AtmosphericBlockTags.ALOE_PLACEABLE);
        }
        return super.mayPlaceOn(state, level, pos);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof LivingEntity) {
            if (!entity.getType().is(AtmosphericEntityTypeTags.ALOE_IMMUNE)) {
                entity.makeStuckInBlock(state, new Vec3((double)0.8f, 0.75, (double)0.8f));
            }
            RandomSource random = entity.getRandom();
            for (int i = 0; i < 3; ++i) {
                double offsetX = random.nextFloat() * 0.6f;
                double offsetZ = random.nextFloat() * 0.45f;
                double x = (double)pos.getX() + 0.5 + offsetX;
                double y = (double)pos.getY() + 0.5 + (double)(random.nextFloat() * 0.05f);
                double z = (double)pos.getZ() + 0.65 + offsetZ;
                if (state.getValue((Property)HALF) != DoubleBlockHalf.UPPER || !level.isClientSide || level.getGameTime() % (long)(9 / ((Integer)state.getValue((Property)AGE) - 5)) != 0L) continue;
                level.addParticle((ParticleOptions)AtmosphericParticleTypes.ALOE_BLOSSOM.get(), x, y, z, 0.03, 0.0, 0.03);
            }
            if (!level.isClientSide && (Integer)state.getValue((Property)AGE) > 3 && (double)random.nextFloat() <= 0.4 && state.getValue((Property)HALF) == DoubleBlockHalf.LOWER && !entity.getType().is(AtmosphericEntityTypeTags.ALOE_IMMUNE)) {
                entity.makeStuckInBlock(state, new Vec3((double)0.2f, 0.2, (double)0.2f));
                entity.hurt(AtmosphericDamageTypes.aloeLeaves(level), 1.0f);
                if (entity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    if (!entity.getCommandSenderWorld().isClientSide() && !serverPlayer.isCreative()) {
                        ((PlayerTrigger)AtmosphericCriteriaTriggers.ALOE_VERA_PRICK.get()).trigger(serverPlayer);
                    }
                }
            }
        }
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)AtmosphericItems.ALOE_KERNELS.get());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        double offsetX = rand.nextFloat() * 0.6f;
        double offsetZ = rand.nextFloat() * 0.45f;
        double x = (double)pos.getX() + 0.5 + offsetX;
        double y = (double)pos.getY() + 0.5 + (double)(rand.nextFloat() * 0.05f);
        double z = (double)pos.getZ() + 0.65 + offsetZ;
        if (state.getValue((Property)HALF) == DoubleBlockHalf.UPPER && level.isClientSide && level.getGameTime() % (long)(6 / ((Integer)state.getValue((Property)AGE) - 5)) == 0L) {
            level.addParticle((ParticleOptions)AtmosphericParticleTypes.ALOE_BLOSSOM.get(), x, y, z, 0.03, 0.0, 0.03);
        }
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is(Items.BONE_MEAL)) {
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        int age = (Integer)state.getValue((Property)AGE);
        RandomSource rand = level.getRandom();
        if (stack.is(Tags.Items.TOOLS_SHEAR)) {
            stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            for (int i = 0; i < 50 + rand.nextInt(50); ++i) {
                double offsetX = rand.nextFloat();
                double offsetZ = rand.nextFloat();
                double x = (double)pos.getX() + offsetX;
                double y = (double)pos.getY() + 0.5 + (double)rand.nextFloat();
                double z = (double)pos.getZ() + 0.15 + offsetZ;
                if (!level.isClientSide) continue;
                level.addParticle((ParticleOptions)AtmosphericParticleTypes.ALOE_BLOSSOM.get(), x, y, z, 0.03, 0.0, 0.03);
            }
            level.playSound(null, pos, SoundEvents.SHEEP_SHEAR, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
            AloeVeraTallBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)AtmosphericItems.YELLOW_BLOSSOMS.get(), age - 5));
            AloeVeraTallBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)AtmosphericItems.ALOE_KERNELS.get()));
            if (state.getValue((Property)HALF) == DoubleBlockHalf.LOWER) {
                level.playSound(null, pos, SoundEvents.SLIME_BLOCK_BREAK, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
                level.setBlock(pos.above(), Blocks.AIR.defaultBlockState(), 18);
                level.setBlock(pos, (BlockState)((Block)AtmosphericBlocks.ALOE_VERA.get()).defaultBlockState().setValue((Property)AloeVeraBlock.AGE, (Comparable)Integer.valueOf(2)), 18);
                AloeVeraTallBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)AtmosphericItems.ALOE_LEAVES.get(), rand.nextInt(5) + 3));
            } else {
                level.setBlock(pos.below(), (BlockState)((Block)AtmosphericBlocks.ALOE_VERA.get()).defaultBlockState().setValue((Property)AloeVeraBlock.AGE, (Comparable)Integer.valueOf(5)), 18);
                level.setBlock(pos, Blocks.AIR.defaultBlockState(), 18);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return this.mayPlaceOn(state, (BlockGetter)level, pos);
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 8;
    }

    public boolean isBonemealSuccess(Level level, RandomSource rand, BlockPos pos, BlockState state) {
        return true;
    }

    @Nullable
    public PathType getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, @Nullable Mob entity) {
        return PathType.DAMAGE_OTHER;
    }

    @Nullable
    public PathType getAdjacentBlockPathType(BlockState state, BlockGetter world, BlockPos pos, @Nullable Mob entity, PathType originalType) {
        return PathType.DANGER_OTHER;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        boolean flag;
        if (state.getValue((Property)HALF) == DoubleBlockHalf.LOWER && (flag = level.getBlockState(pos.below()).is(AtmosphericBlockTags.TALL_ALOE_GROWABLE_ON)) && (Integer)state.getValue((Property)AGE) < 8 && level.getRawBrightness(pos.above(), 0) >= 12 && CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)state, (random.nextInt(7) == 0 ? 1 : 0) != 0)) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf((Integer)state.getValue((Property)AGE) + 1)));
            level.setBlockAndUpdate(pos.above(), (BlockState)((BlockState)state.setValue((Property)HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)AGE, (Comparable)Integer.valueOf((Integer)state.getValue((Property)AGE) + 1)));
            CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public void performBonemeal(ServerLevel level, RandomSource rand, BlockPos pos, BlockState state) {
        int age = (Integer)state.getValue((Property)AGE);
        DoubleBlockHalf half = (DoubleBlockHalf)state.getValue((Property)HALF);
        if (age < 8) {
            if (half == DoubleBlockHalf.LOWER) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age + 1)));
                level.setBlockAndUpdate(pos.above(), (BlockState)((BlockState)state.setValue((Property)HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)AGE, (Comparable)Integer.valueOf(age + 1)));
            } else if (half == DoubleBlockHalf.UPPER) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age + 1)));
                level.setBlockAndUpdate(pos.below(), (BlockState)((BlockState)state.setValue((Property)HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)AGE, (Comparable)Integer.valueOf(age + 1)));
            }
        }
    }
}

