/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.block;

import com.mojang.serialization.MapCodec;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.atmospheric.core.registry.datapack.AtmosphericBiomes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class AridSandBlock
extends FallingBlock
implements BonemealableBlock {
    private final int color;

    public AridSandBlock(int color, BlockBehaviour.Properties properties) {
        super(properties);
        this.color = color;
    }

    protected MapCodec<? extends FallingBlock> codec() {
        return null;
    }

    public int getDustColor(BlockState state, BlockGetter reader, BlockPos pos) {
        return this.color;
    }

    public boolean isValidBonemealTarget(LevelReader worldIn, BlockPos pos, BlockState state) {
        return worldIn.getBlockState(pos.above()).isAir();
    }

    public boolean isBonemealSuccess(Level worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        BlockPos blockpos = pos.above();
        BlockState blockstate = ((Block)AtmosphericBlocks.ARID_SPROUTS.get()).defaultBlockState();
        block0: for (int i = 0; i < 128; ++i) {
            Holder biome;
            BlockPos blockpos1 = blockpos;
            for (int j = 0; j < i / 16; ++j) {
                if (!worldIn.getBlockState((blockpos1 = blockpos1.offset(rand.nextInt(3) - 1, (rand.nextInt(3) - 1) * rand.nextInt(3) / 2, rand.nextInt(3) - 1)).below()).is((Block)this) || worldIn.getBlockState(blockpos1).isCollisionShapeFullBlock((BlockGetter)worldIn, blockpos1)) continue block0;
            }
            BlockState blockstate2 = worldIn.getBlockState(blockpos1);
            if (!blockstate2.isAir()) continue;
            BlockState blockstate1 = rand.nextInt(8) == 0 ? ((biome = worldIn.getBiome(blockpos1)).is(AtmosphericBiomes.FLOURISHING_DUNES) ? ((Block)AtmosphericBlocks.GILIA.get()).defaultBlockState() : ((Block)AtmosphericBlocks.YUCCA_FLOWER.get()).defaultBlockState()) : blockstate;
            if (!blockstate1.canSurvive((LevelReader)worldIn, blockpos1)) continue;
            worldIn.setBlock(blockpos1, blockstate1, 3);
            if (!blockstate1.is((Block)AtmosphericBlocks.YUCCA_FLOWER.get()) || rand.nextInt(10) != 0) continue;
            ((BonemealableBlock)blockstate1.getBlock()).performBonemeal(worldIn, rand, blockpos1, blockstate1);
        }
    }
}

