/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.block;

import com.teamabnormals.atmospheric.core.other.tags.AtmosphericBlockTags;
import com.teamabnormals.atmospheric.core.other.tags.AtmosphericEntityTypeTags;
import com.teamabnormals.atmospheric.core.registry.AtmosphericCriteriaTriggers;
import com.teamabnormals.atmospheric.core.registry.AtmosphericItems;
import com.teamabnormals.atmospheric.core.registry.AtmosphericMobEffects;
import com.teamabnormals.atmospheric.core.registry.datapack.AtmosphericDamageTypes;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;

public class BarrelCactusBlock
extends Block
implements BonemealableBlock {
    public static final IntegerProperty AGE = BlockStateProperties.AGE_3;
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0), Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
    private static final VoxelShape[] COLLISION_BY_AGE = new VoxelShape[]{Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)3.0, (double)9.0), Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)7.0, (double)11.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)11.0, (double)13.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0)};

    public BarrelCactusBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = context.getLevel().getBlockState(context.getClickedPos());
        if (state.getBlock() instanceof BarrelCactusBlock) {
            return (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(Math.min(3, (Integer)state.getValue((Property)AGE) + 1)));
        }
        return this.defaultBlockState();
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return useContext.getItemInHand().getItem() == AtmosphericItems.BARREL_CACTUS.get() && (Integer)state.getValue((Property)AGE) < 3 || super.canBeReplaced(state, useContext);
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)AtmosphericItems.BARREL_CACTUS.get());
    }

    public void performBonemeal(ServerLevel worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        int i = (Integer)state.getValue((Property)AGE);
        if (i < 3 && CommonHooks.canCropGrow((Level)worldIn, (BlockPos)pos, (BlockState)state, (rand.nextInt(3) == 0 ? 1 : 0) != 0)) {
            worldIn.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(i + 1)));
            CommonHooks.fireCropGrowPost((Level)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return COLLISION_BY_AGE[(Integer)state.getValue((Property)AGE)];
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[(Integer)state.getValue((Property)AGE)];
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            level.destroyBlock(pos, true);
        }
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!stateIn.canSurvive((LevelReader)worldIn, currentPos)) {
            worldIn.scheduleTick(currentPos, (Block)this, 1);
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockState downState = worldIn.getBlockState(pos.below());
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (!(worldIn.getBlockState(pos.relative(direction)).getBlock() instanceof CactusBlock)) continue;
            return false;
        }
        return downState.is(AtmosphericBlockTags.BARREL_CACTUS_PLACEABLE) && !worldIn.getBlockState(pos.above()).liquid();
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!entity.getType().is(AtmosphericEntityTypeTags.CACTUS_IMMUNE) && (Integer)state.getValue((Property)AGE) > 0) {
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                if ((Integer)state.getValue((Property)AGE) != 0) {
                    living.addEffect(new MobEffectInstance(AtmosphericMobEffects.WORSENING, ((Integer)state.getValue((Property)AGE) + 1) * 40));
                }
            }
            if (level.getGameTime() % 20L == 0L) {
                LivingEntity living;
                float damage = 0.5f * (float)((Integer)state.getValue((Property)AGE)).intValue();
                if (entity instanceof LivingEntity && (living = (LivingEntity)entity).getItemBySlot(EquipmentSlot.HEAD).is((Item)AtmosphericItems.BARREL_CACTUS.get())) {
                    damage /= 2.0f;
                }
                entity.hurt(AtmosphericDamageTypes.barrelCactus(level), damage);
                if (entity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    if (!entity.getCommandSenderWorld().isClientSide() && !serverPlayer.isCreative()) {
                        ((PlayerTrigger)AtmosphericCriteriaTriggers.BARREL_CACTUS_PRICK.get()).trigger(serverPlayer);
                    }
                }
            }
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    @Nullable
    public PathType getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, @Nullable Mob entity) {
        return entity != null && entity.getType().is(AtmosphericEntityTypeTags.CACTUS_IMMUNE) ? null : PathType.DAMAGE_OTHER;
    }

    @Nullable
    public PathType getAdjacentBlockPathType(BlockState state, BlockGetter world, BlockPos pos, @Nullable Mob entity, PathType originalType) {
        return entity != null && entity.getType().is(AtmosphericEntityTypeTags.CACTUS_IMMUNE) ? null : PathType.DANGER_OTHER;
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 3;
    }

    public boolean isBonemealSuccess(Level worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 3;
    }
}

