/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import com.teamabnormals.atmospheric.common.block.YuccaGateauBlock;
import com.teamabnormals.atmospheric.core.other.tags.AtmosphericBlockTags;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;

public class CandleGateauBlock
extends AbstractCandleBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty LIT = AbstractCandleBlock.LIT;
    protected static final VoxelShape GATEAU_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0);
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{Shapes.or((VoxelShape)GATEAU_SHAPE, (VoxelShape)Block.box((double)5.0, (double)6.0, (double)9.0, (double)7.0, (double)12.0, (double)11.0)), Shapes.or((VoxelShape)GATEAU_SHAPE, (VoxelShape)Block.box((double)5.0, (double)6.0, (double)5.0, (double)7.0, (double)12.0, (double)7.0)), Shapes.or((VoxelShape)GATEAU_SHAPE, (VoxelShape)Block.box((double)9.0, (double)6.0, (double)5.0, (double)11.0, (double)12.0, (double)7.0)), Shapes.or((VoxelShape)GATEAU_SHAPE, (VoxelShape)Block.box((double)9.0, (double)6.0, (double)9.0, (double)11.0, (double)12.0, (double)11.0))};
    private static final Map<CandleBlock, CandleGateauBlock> BY_CANDLE = Maps.newHashMap();
    private static final Iterable<Vec3>[] PARTICLE_OFFSETS = new Iterable[]{ImmutableList.of((Object)new Vec3(0.375, 0.875, 0.625)), ImmutableList.of((Object)new Vec3(0.375, 0.875, 0.375)), ImmutableList.of((Object)new Vec3(0.625, 0.875, 0.375)), ImmutableList.of((Object)new Vec3(0.625, 0.875, 0.625))};
    private final Block candle;

    public CandleGateauBlock(Block candle, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
        this.candle = candle;
        BY_CANDLE.put((CandleBlock)candle, this);
    }

    protected MapCodec<? extends AbstractCandleBlock> codec() {
        return null;
    }

    protected Iterable<Vec3> getParticleOffsets(BlockState state) {
        return PARTICLE_OFFSETS[((Direction)state.getValue((Property)FACING)).get2DDataValue()];
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES[((Direction)state.getValue((Property)FACING)).get2DDataValue()];
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is(Items.FLINT_AND_STEEL) || stack.is(Items.FIRE_CHARGE)) {
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        if (CandleGateauBlock.candleHit(hitResult) && stack.isEmpty() && ((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            CandleGateauBlock.extinguish((Player)player, (BlockState)state, (LevelAccessor)level, (BlockPos)pos);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        InteractionResult result = YuccaGateauBlock.eat((LevelAccessor)level, pos, (BlockState)((Block)AtmosphericBlocks.YUCCA_GATEAU.get()).defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING))), player);
        if (result.consumesAction()) {
            CandleGateauBlock.dropResources((BlockState)state, (Level)level, (BlockPos)pos);
        }
        return result;
    }

    private static boolean candleHit(BlockHitResult hit) {
        return hit.getLocation().y - (double)hit.getBlockPos().getY() > 0.5;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT, FACING});
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack(AtmosphericBlocks.YUCCA_GATEAU);
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        return direction == Direction.DOWN && !state.canSurvive((LevelReader)level, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return level.getBlockState(pos.below()).isSolid();
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return CakeBlock.FULL_CAKE_SIGNAL;
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public static BlockState byCandle(CandleBlock candle) {
        return BY_CANDLE.get(candle).defaultBlockState();
    }

    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ItemAbility itemAbility, boolean simulate) {
        if (ItemAbilities.FIRESTARTER_LIGHT == itemAbility && CandleGateauBlock.canLight(state)) {
            return (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true));
        }
        return super.getToolModifiedState(state, context, itemAbility, simulate);
    }

    public static boolean canLight(BlockState state) {
        return state.is(AtmosphericBlockTags.CANDLE_YUCCA_GATEAUS, baseState -> baseState.hasProperty((Property)LIT) && (Boolean)state.getValue((Property)LIT) == false);
    }

    public Block getCandle() {
        return this.candle;
    }

    public static Iterable<CandleGateauBlock> getCandleGateaus() {
        return BuiltInRegistries.BLOCK.stream().filter(block -> "atmospheric".equals(BuiltInRegistries.BLOCK.getKey(block).getNamespace()) && block instanceof CandleGateauBlock).map(block -> (CandleGateauBlock)((Object)block)).collect(Collectors.toList());
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

