/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.block;

import com.teamabnormals.atmospheric.core.other.tags.AtmosphericBlockTags;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.blueprint.core.util.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LightEngine;

public interface Crustose {
    public Block getUnspreadBlock();

    public static boolean canBeGrass(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos blockpos = pos.above();
        BlockState blockstate = world.getBlockState(blockpos);
        if (blockstate.getFluidState().getAmount() == 8) {
            return false;
        }
        int i = LightEngine.getLightBlockInto((BlockGetter)world, (BlockState)state, (BlockPos)pos, (BlockState)blockstate, (BlockPos)blockpos, (Direction)Direction.UP, (int)blockstate.getLightBlock((BlockGetter)world, blockpos));
        return i < world.getMaxLightLevel();
    }

    public static boolean canPropagate(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.above();
        return Crustose.canBeGrass(state, level, pos) && !level.getFluidState(blockpos).is(FluidTags.WATER) && !level.getBlockState(blockpos).is(AtmosphericBlockTags.CRUSTOSE_CANNOT_SPREAD_UNDER);
    }

    default public void randomCrustoseTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!Crustose.canBeGrass(state, (LevelReader)level, pos)) {
            if (!level.isAreaLoaded(pos, 1)) {
                return;
            }
            level.setBlockAndUpdate(pos, BlockUtil.transferAllBlockStates((BlockState)state, (BlockState)this.getUnspreadBlock().defaultBlockState()));
        } else {
            if (!level.isAreaLoaded(pos, 3)) {
                return;
            }
            if (level.getMaxLocalRawBrightness(pos.above()) >= 9) {
                for (int i = 0; i < 4; ++i) {
                    BlockState newState;
                    Block newBlock;
                    BlockPos offsetPos = pos.offset(random.nextInt(3) - 1, random.nextInt(5) - 3, random.nextInt(3) - 1);
                    BlockState offsetState = level.getBlockState(offsetPos);
                    Object object = offsetState.is(Blocks.DIRT) ? (Block)AtmosphericBlocks.CRUSTOSE.get() : (offsetState.is((Block)AtmosphericBlocks.ASPEN_LOG.get()) ? (Block)AtmosphericBlocks.CRUSTOSE_LOG.get() : (newBlock = offsetState.is((Block)AtmosphericBlocks.ASPEN_WOOD.get()) ? (Block)AtmosphericBlocks.CRUSTOSE_WOOD.get() : null));
                    if (newBlock == null || !Crustose.canPropagate(newState = BlockUtil.transferAllBlockStates((BlockState)level.getBlockState(offsetPos), (BlockState)newBlock.defaultBlockState()), (LevelReader)level, offsetPos)) continue;
                    level.setBlockAndUpdate(offsetPos, newState);
                }
            }
        }
    }

    default public boolean isCrustoseValidBonemealTarget(BlockGetter level, BlockPos pos, BlockState state) {
        return level.getBlockState(pos.above()).isAir();
    }

    default public void performCrustoseBonemeal(Block block, ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        BlockPos abovePos = pos.above();
        BlockState crustoseSprouts = ((Block)AtmosphericBlocks.GOLDEN_GROWTHS.get()).defaultBlockState();
        block0: for (int i = 0; i < 128; ++i) {
            BlockPos offsetPos = abovePos;
            for (int j = 0; j < i / 16; ++j) {
                if (!level.getBlockState((offsetPos = offsetPos.offset(random.nextInt(3) - 1, (random.nextInt(3) - 1) * random.nextInt(3) / 2, random.nextInt(3) - 1)).below()).is(block) || level.getBlockState(offsetPos).isCollisionShapeFullBlock((BlockGetter)level, offsetPos)) continue block0;
            }
            if (!level.getBlockState(offsetPos).isAir() || !crustoseSprouts.canSurvive((LevelReader)level, offsetPos)) continue;
            level.setBlock(offsetPos, crustoseSprouts, 3);
        }
    }
}

