/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.block;

import com.teamabnormals.atmospheric.core.other.AtmosphericTreeGrowers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CurrantSeedlingBlock
extends SaplingBlock {
    protected static final VoxelShape SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0);

    public CurrantSeedlingBlock(BlockBehaviour.Properties properties) {
        super(AtmosphericTreeGrowers.CURRANT, properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int speed;
        int n = speed = ((Biome)level.getBiome(pos).value()).coldEnoughToSnow(pos) ? 2 : 4;
        if (level.getMaxLocalRawBrightness(pos.above()) >= 9 && random.nextInt(speed) == 0) {
            if (!level.isAreaLoaded(pos, 1)) {
                return;
            }
            this.advanceTree(level, pos, state, random);
        }
    }
}

