/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.block;

import com.teamabnormals.atmospheric.common.block.CurrantLeavesBlock;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.common.Tags;

public class CurrantStalkBundleBlock
extends RotatedPillarBlock {
    public CurrantStalkBundleBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void onCaughtFire(BlockState state, Level level, BlockPos pos, @Nullable Direction face, @Nullable LivingEntity igniter) {
        if (!level.isClientSide()) {
            level.destroyBlock(pos, true);
            CurrantStalkBundleBlock.breakLeaves((LevelAccessor)level, pos);
            this.breakStalks(state, level, pos);
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.isClientSide()) {
            CurrantStalkBundleBlock.breakLeaves((LevelAccessor)level, pos);
            this.breakStalks(state, (Level)level, pos);
            level.destroyBlock(pos, true);
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        ItemStack stack = player.getMainHandItem();
        if (stack.is(Tags.Items.TOOLS_SHEAR) || EnchantmentHelper.hasTag((ItemStack)stack, (TagKey)EnchantmentTags.PREVENTS_BEE_SPAWNS_WHEN_MINING) || player.hasInfiniteMaterials()) {
            this.playerWillDestroy(level, pos, state, player);
            level.setBlock(pos, fluid.createLegacyBlock(), level.isClientSide ? 11 : 3);
            if (!player.isCreative()) {
                CurrantStalkBundleBlock.dropResources((BlockState)state, (Level)level, (BlockPos)pos, null, (Entity)player, (ItemStack)player.getMainHandItem());
            }
            return false;
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public void destroy(LevelAccessor level, BlockPos pos, BlockState state) {
        if (!level.isClientSide()) {
            CurrantStalkBundleBlock.breakLeaves(level, pos);
            this.breakStalks(state, (Level)level, pos);
        }
        super.destroy(level, pos, state);
    }

    public static void breakLeaves(LevelAccessor level, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockPos offsetPos = pos.relative(direction);
            BlockState offsetState = level.getBlockState(offsetPos);
            Block block = offsetState.getBlock();
            if (!(block instanceof CurrantLeavesBlock)) continue;
            CurrantLeavesBlock currantLeaves = (CurrantLeavesBlock)block;
            level.scheduleTick(offsetPos, (Block)currantLeaves, 2 + level.getRandom().nextInt(2));
        }
    }

    public void breakStalks(BlockState state, Level level, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            if (!this.isValidDirection(state, direction)) continue;
            BlockPos offsetPos = pos.relative(direction);
            BlockState offsetState = level.getBlockState(offsetPos);
            level.scheduleTick(offsetPos, offsetState.getBlock(), 2 + level.getRandom().nextInt(2));
        }
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    public boolean isValidDirection(BlockState state, Direction direction) {
        return true;
    }
}

