/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import com.teamabnormals.atmospheric.common.block.state.properties.DragonRootsStage;
import com.teamabnormals.atmospheric.common.entity.projectile.DragonFruit;
import com.teamabnormals.atmospheric.core.registry.AtmosphericEntityTypes;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;

public class DragonRootsBlock
extends BushBlock
implements BonemealableBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<DragonRootsStage> TOP_STAGE = EnumProperty.create((String)"top", DragonRootsStage.class);
    public static final EnumProperty<DragonRootsStage> BOTTOM_STAGE = EnumProperty.create((String)"bottom", DragonRootsStage.class);
    private static final Map<Direction, VoxelShape> SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.box((double)0.0, (double)1.0, (double)5.0, (double)16.0, (double)15.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.box((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)15.0, (double)11.0), (Object)Direction.WEST, (Object)Block.box((double)5.0, (double)1.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0), (Object)Direction.EAST, (Object)Block.box((double)0.0, (double)1.0, (double)0.0, (double)11.0, (double)15.0, (double)16.0)));
    private static final Map<Direction, VoxelShape> SHAPES_TOP = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.box((double)0.0, (double)8.0, (double)5.0, (double)16.0, (double)15.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)15.0, (double)11.0), (Object)Direction.WEST, (Object)Block.box((double)5.0, (double)8.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0), (Object)Direction.EAST, (Object)Block.box((double)0.0, (double)8.0, (double)0.0, (double)11.0, (double)15.0, (double)16.0)));
    private static final Map<Direction, VoxelShape> SHAPES_BOTTOM = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.box((double)0.0, (double)1.0, (double)5.0, (double)16.0, (double)8.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.box((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)8.0, (double)11.0), (Object)Direction.WEST, (Object)Block.box((double)5.0, (double)1.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), (Object)Direction.EAST, (Object)Block.box((double)0.0, (double)1.0, (double)0.0, (double)11.0, (double)8.0, (double)16.0)));

    public DragonRootsBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(TOP_STAGE, (Comparable)((Object)DragonRootsStage.ROOTS))).setValue(BOTTOM_STAGE, (Comparable)((Object)DragonRootsStage.ROOTS)));
    }

    protected MapCodec<? extends BushBlock> codec() {
        return null;
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return true;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockPos offsetPos = pos.relative(direction.getOpposite());
        return level.getBlockState(offsetPos).isFaceSturdy((BlockGetter)level, offsetPos, direction);
    }

    public static boolean hasFruit(BlockState state) {
        return DragonRootsBlock.hasFruit(TOP_STAGE, state) || DragonRootsBlock.hasFruit(BOTTOM_STAGE, state);
    }

    public static boolean hasMaxFruit(BlockState state) {
        return DragonRootsBlock.isDouble(state) ? DragonRootsBlock.hasFruit(TOP_STAGE, state) && DragonRootsBlock.hasFruit(BOTTOM_STAGE, state) : DragonRootsBlock.hasFruit(state);
    }

    public static boolean hasFruit(EnumProperty<DragonRootsStage> property, BlockState state) {
        DragonRootsStage stage = (DragonRootsStage)((Object)state.getValue(property));
        return stage == DragonRootsStage.FRUIT || stage == DragonRootsStage.FLOWERING || DragonRootsBlock.isEnder(property, state);
    }

    public static boolean isFlowering(BlockState state) {
        return DragonRootsBlock.isFlowering(TOP_STAGE, state) || DragonRootsBlock.isFlowering(BOTTOM_STAGE, state);
    }

    public static boolean isFlowering(EnumProperty<DragonRootsStage> property, BlockState state) {
        DragonRootsStage stage = (DragonRootsStage)((Object)state.getValue(property));
        return stage == DragonRootsStage.FLOWERING || stage == DragonRootsStage.FLOWERING_ENDER;
    }

    public static boolean isDouble(BlockState state) {
        return state.getValue(TOP_STAGE) != DragonRootsStage.NONE && state.getValue(BOTTOM_STAGE) != DragonRootsStage.NONE;
    }

    public static boolean isEnder(EnumProperty<DragonRootsStage> property, BlockState state) {
        DragonRootsStage stage = (DragonRootsStage)((Object)state.getValue(property));
        return stage == DragonRootsStage.ENDER || stage == DragonRootsStage.FLOWERING_ENDER;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return !DragonRootsBlock.hasMaxFruit(state) && stack.is(Items.BONE_MEAL) ? ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION : super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (DragonRootsBlock.hasFruit(state)) {
            level.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
            BlockState newState = state;
            if (DragonRootsBlock.hasFruit(TOP_STAGE, state)) {
                newState = (BlockState)newState.setValue(TOP_STAGE, (Comparable)((Object)DragonRootsStage.ROOTS));
            }
            if (DragonRootsBlock.hasFruit(BOTTOM_STAGE, state)) {
                newState = (BlockState)newState.setValue(BOTTOM_STAGE, (Comparable)((Object)DragonRootsStage.ROOTS));
            }
            level.setBlock(pos, newState, 2);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)newState));
            DragonRootsBlock.dropFruits(state, level, pos);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    public static void dropFruits(BlockState state, Level level, BlockPos pos) {
        Direction dir = (Direction)state.getValue((Property)FACING);
        if (DragonRootsBlock.hasFruit(TOP_STAGE, state)) {
            DragonRootsBlock.addDragonFruitWithOffset(TOP_STAGE, state, level, pos, dir == Direction.NORTH || dir == Direction.EAST ? 0.25f : 0.75f, 0.75f, dir.getAxisDirection() == Direction.AxisDirection.NEGATIVE ? 0.75f : 0.25f);
        }
        if (DragonRootsBlock.hasFruit(BOTTOM_STAGE, state)) {
            DragonRootsBlock.addDragonFruitWithOffset(BOTTOM_STAGE, state, level, pos, dir.getAxisDirection() == Direction.AxisDirection.NEGATIVE ? 0.75f : 0.25f, 0.25f, dir == Direction.NORTH || dir == Direction.EAST ? 0.75f : 0.25f);
        }
    }

    public void destroy(LevelAccessor levelAccessor, BlockPos pos, BlockState state) {
        if (!levelAccessor.isClientSide() && DragonRootsBlock.hasFruit(state) && levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            DragonRootsBlock.dropFruits(state, level, pos);
        }
        super.destroy(levelAccessor, pos, state);
    }

    public static void addDragonFruitWithOffset(EnumProperty<DragonRootsStage> property, BlockState state, Level level, BlockPos pos, float x, float y, float z) {
        DragonFruit dragonFruit = (DragonFruit)((EntityType)AtmosphericEntityTypes.DRAGON_FRUIT.get()).create(level);
        dragonFruit.setEnder(DragonRootsBlock.isEnder(property, state));
        dragonFruit.setFlowering(DragonRootsBlock.isFlowering(property, state));
        dragonFruit.setPos((float)pos.getX() + x, (float)pos.getY() + y, (float)pos.getZ() + z);
        dragonFruit.setRollingDirection((Direction)state.getValue((Property)FACING));
        dragonFruit.setYRot(((Direction)state.getValue((Property)FACING)).toYRot());
        level.addFreshEntity((Entity)dragonFruit);
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, TOP_STAGE, BOTTOM_STAGE});
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        return !context.isSecondaryUseActive() && context.getItemInHand().getItem() == this.asItem() && !DragonRootsBlock.isDouble(state) || super.canBeReplaced(state, context);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos;
        BlockState state;
        Level level = context.getLevel();
        Direction direction = context.getClickedFace();
        if (direction.getAxis().isVertical()) {
            direction = context.getHorizontalDirection().getOpposite();
        }
        if ((state = level.getBlockState(pos = context.getClickedPos())).is((Block)this) && !DragonRootsBlock.isDouble(state)) {
            if (state.getValue(TOP_STAGE) == DragonRootsStage.NONE) {
                return (BlockState)state.setValue(TOP_STAGE, (Comparable)((Object)DragonRootsStage.ROOTS));
            }
            if (state.getValue(BOTTOM_STAGE) == DragonRootsStage.NONE) {
                return (BlockState)state.setValue(BOTTOM_STAGE, (Comparable)((Object)DragonRootsStage.ROOTS));
            }
        }
        boolean top = context.getClickLocation().y - (double)pos.getY() > 0.5;
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction)).setValue(top ? TOP_STAGE : BOTTOM_STAGE, (Comparable)((Object)DragonRootsStage.ROOTS))).setValue(!top ? TOP_STAGE : BOTTOM_STAGE, (Comparable)((Object)DragonRootsStage.NONE));
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockState newState = state;
        boolean fruitingConditions = level.getRawBrightness(pos, 0) >= 12 && level.isDay() || level.getRawBrightness(pos, 15) >= 12;
        boolean floweringConditions = level.getRawBrightness(pos, 0) <= 3 || level.getRawBrightness(pos, 15) <= 3 && level.isNight();
        boolean cropGrew = false;
        if (state.getValue(TOP_STAGE) == DragonRootsStage.ROOTS && fruitingConditions && CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)state, (random.nextInt(10) == 0 ? 1 : 0) != 0)) {
            newState = (BlockState)state.setValue(TOP_STAGE, (Comparable)((Object)DragonRootsBlock.getFruitStage(level)));
            cropGrew = true;
        }
        if (state.getValue(BOTTOM_STAGE) == DragonRootsStage.ROOTS && fruitingConditions && CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)state, (random.nextInt(10) == 0 ? 1 : 0) != 0)) {
            newState = (BlockState)state.setValue(BOTTOM_STAGE, (Comparable)((Object)DragonRootsBlock.getFruitStage(level)));
            cropGrew = true;
        }
        if (DragonRootsBlock.hasFruit(TOP_STAGE, state) && DragonRootsBlock.isFlowering(TOP_STAGE, state) != floweringConditions) {
            newState = (BlockState)newState.setValue(TOP_STAGE, (Comparable)((Object)DragonRootsBlock.switchFruitAndFlowering((DragonRootsStage)((Object)state.getValue(TOP_STAGE)))));
        }
        if (DragonRootsBlock.hasFruit(BOTTOM_STAGE, state) && DragonRootsBlock.isFlowering(BOTTOM_STAGE, state) != floweringConditions) {
            newState = (BlockState)newState.setValue(BOTTOM_STAGE, (Comparable)((Object)DragonRootsBlock.switchFruitAndFlowering((DragonRootsStage)((Object)state.getValue(BOTTOM_STAGE)))));
        }
        if (newState != state) {
            level.setBlock(pos, newState, 2);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)newState));
            if (cropGrew) {
                CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        boolean bottom;
        boolean top = state.getValue(TOP_STAGE) != DragonRootsStage.NONE;
        boolean bl = bottom = state.getValue(BOTTOM_STAGE) != DragonRootsStage.NONE;
        return (top && bottom ? SHAPES : (top ? SHAPES_TOP : SHAPES_BOTTOM)).get(state.getValue((Property)FACING));
    }

    public boolean isValidBonemealTarget(LevelReader worldIn, BlockPos pos, BlockState state) {
        return !DragonRootsBlock.hasMaxFruit(state);
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos blockPos, BlockState blockState) {
        return world.random.nextFloat() < 0.3f;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        boolean bottom;
        boolean top = state.getValue(TOP_STAGE) == DragonRootsStage.ROOTS;
        boolean bl = bottom = state.getValue(BOTTOM_STAGE) == DragonRootsStage.ROOTS;
        if (top || bottom) {
            EnumProperty<DragonRootsStage> property = top && bottom ? (random.nextBoolean() ? TOP_STAGE : BOTTOM_STAGE) : (top ? TOP_STAGE : BOTTOM_STAGE);
            level.setBlockAndUpdate(pos, (BlockState)state.setValue(property, (Comparable)((Object)(DragonRootsBlock.isFlowering(state) ? DragonRootsBlock.getFloweringStage(level) : DragonRootsBlock.getFruitStage(level)))));
        }
    }

    public static DragonRootsStage getFruitStage(ServerLevel level) {
        return level.dimensionTypeRegistration().is(BuiltinDimensionTypes.END) ? DragonRootsStage.ENDER : DragonRootsStage.FRUIT;
    }

    public static DragonRootsStage switchFruitAndFlowering(DragonRootsStage stage) {
        return stage == DragonRootsStage.FLOWERING ? DragonRootsStage.FRUIT : (stage == DragonRootsStage.FRUIT ? DragonRootsStage.FLOWERING : (stage == DragonRootsStage.FLOWERING_ENDER ? DragonRootsStage.ENDER : (stage == DragonRootsStage.ENDER ? DragonRootsStage.FLOWERING_ENDER : DragonRootsStage.NONE)));
    }

    public static DragonRootsStage getFloweringStage(ServerLevel level) {
        return level.dimensionTypeRegistration().is(BuiltinDimensionTypes.END) ? DragonRootsStage.FLOWERING_ENDER : DragonRootsStage.FLOWERING;
    }
}

