/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.block;

import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.atmospheric.core.registry.AtmosphericItems;
import com.teamabnormals.atmospheric.core.registry.AtmosphericParticleTypes;
import com.teamabnormals.blueprint.core.util.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.Tags;

public class FloweringMoradoLeavesBlock
extends LeavesBlock {
    public FloweringMoradoLeavesBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (stack.is(Tags.Items.TOOLS_SHEAR)) {
            stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            level.playSound(null, pos, SoundEvents.SHEEP_SHEAR, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
            level.setBlockAndUpdate(pos, BlockUtil.transferAllBlockStates((BlockState)state, (BlockState)((Block)AtmosphericBlocks.MORADO_LEAVES.get()).defaultBlockState()));
            FloweringMoradoLeavesBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)AtmosphericItems.YELLOW_BLOSSOMS.get(), 1 + player.getRandom().nextInt(3)));
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hit);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        BlockPos blockpos;
        super.animateTick(stateIn, worldIn, pos, rand);
        int color = ((Biome)worldIn.getBiome(pos).value()).getFoliageColor();
        double d0 = (float)(color >> 16 & 0xFF) / 255.0f;
        double d1 = (float)(color >> 8 & 0xFF) / 255.0f;
        double d2 = (float)(color & 0xFF) / 255.0f;
        if (rand.nextInt(40) == 0 && worldIn.isEmptyBlock(blockpos = pos.below())) {
            double d3 = (float)pos.getX() + rand.nextFloat();
            double d4 = (double)pos.getY() - 0.05;
            double d6 = (float)pos.getZ() + rand.nextFloat();
            worldIn.addParticle((ParticleOptions)AtmosphericParticleTypes.MORADO_BLOSSOM.get(), d3, d4, d6, d0, d1, d2);
        }
    }
}

