/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.block;

import com.mojang.serialization.MapCodec;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.atmospheric.core.registry.AtmosphericItems;
import com.teamabnormals.atmospheric.core.registry.AtmosphericSoundEvents;
import com.teamabnormals.blueprint.common.entity.BlueprintFallingBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.Tags;

public class HangingCurrantBlock
extends BushBlock
implements Fallable {
    protected static final VoxelShape SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);

    public HangingCurrantBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BushBlock> codec() {
        return null;
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return state.is((Block)AtmosphericBlocks.CURRANT_LEAVES.get());
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return this.mayPlaceOn(level.getBlockState(pos.above()), (BlockGetter)level, pos.above());
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            this.destroy(level, pos, state);
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, direction, facingState, level, pos, facingPos);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (player.getMainHandItem().is(Tags.Items.TOOLS_SHEAR)) {
            this.playerWillDestroy(level, pos, state, player);
            level.setBlock(pos, fluid.createLegacyBlock(), level.isClientSide ? 11 : 3);
            if (!player.isCreative()) {
                HangingCurrantBlock.dropResources((BlockState)state, (Level)level, (BlockPos)pos, null, (Entity)player, (ItemStack)player.getMainHandItem());
            }
            return false;
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public void destroy(LevelAccessor levelAccessor, BlockPos pos, BlockState state) {
        if (!levelAccessor.isClientSide() && levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            BlueprintFallingBlockEntity.fall((Level)level, (BlockPos)pos, (BlockState)state).setAllowsPlacing(false);
        }
        super.destroy(levelAccessor, pos, state);
    }

    public void onBrokenAfterFall(Level level, BlockPos pos, FallingBlockEntity entity) {
        BlockState state = level.getBlockState(pos);
        BlockState newState = ((Block)AtmosphericBlocks.CURRANT_SEEDLING.get()).defaultBlockState();
        if ((state.isAir() || state.is(BlockTags.REPLACEABLE)) && newState.canSurvive((LevelReader)level, pos)) {
            level.setBlockAndUpdate(pos, newState);
        } else {
            for (int i = 0; i < 2 + level.random.nextInt(3); ++i) {
                HangingCurrantBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)AtmosphericItems.CURRANT.get()));
            }
        }
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        HangingCurrantBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)AtmosphericItems.CURRANT.get(), 2 + level.random.nextInt(3)));
        level.playSound(null, pos, (SoundEvent)AtmosphericSoundEvents.HANGING_CURRANT_PICK_CURRANT.get(), SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
        level.removeBlock(pos, true);
        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)Blocks.AIR.defaultBlockState()));
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }
}

