/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.block;

import com.teamabnormals.atmospheric.core.other.tags.AtmosphericBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;

public class LaurelSaplingBlock
extends SaplingBlock {
    protected final TreeGrower oranges;
    protected final TreeGrower nether;

    public LaurelSaplingBlock(TreeGrower tree, TreeGrower oranges, TreeGrower nether, BlockBehaviour.Properties properties) {
        super(tree, properties);
        this.oranges = oranges;
        this.nether = nether;
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return state.is(BlockTags.SAND) || super.mayPlaceOn(state, worldIn, pos);
    }

    public void advanceTree(ServerLevel level, BlockPos pos, BlockState state, RandomSource random) {
        if ((Integer)state.getValue((Property)STAGE) == 0) {
            level.setBlock(pos, (BlockState)state.cycle((Property)STAGE), 4);
        } else {
            boolean nether = level.dimensionTypeRegistration().is(BuiltinDimensionTypes.NETHER);
            boolean oranges = LaurelSaplingBlock.hasOranges((LevelAccessor)level, pos);
            TreeGrower grower = oranges ? (nether ? this.nether : this.oranges) : this.treeGrower;
            grower.growTree(level, level.getChunkSource().getGenerator(), pos, state, random);
        }
    }

    private static boolean hasOranges(LevelAccessor level, BlockPos pos) {
        for (BlockPos offsetPos : BlockPos.MutableBlockPos.betweenClosed((BlockPos)pos.below().north(3).west(3), (BlockPos)pos.above(5).south(3).east(3))) {
            if (!level.getBlockState(offsetPos).is(AtmosphericBlockTags.ORANGES)) continue;
            return true;
        }
        return false;
    }
}

