/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.block;

import com.google.common.collect.Lists;
import com.teamabnormals.atmospheric.common.block.WallMonkeyBrushBlock;
import com.teamabnormals.atmospheric.core.other.tags.AtmosphericBlockTags;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.atmospheric.core.registry.AtmosphericMobEffects;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MonkeyBrushBlock
extends FlowerBlock
implements BonemealableBlock {
    public static final DirectionProperty FACING = DirectionProperty.create((String)"facing", (Predicate)Direction.Plane.VERTICAL);
    protected static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);

    public MonkeyBrushBlock(BlockBehaviour.Properties properties) {
        super(AtmosphericMobEffects.RELIEF, 6.0f, properties);
        if (!(this instanceof WallMonkeyBrushBlock)) {
            this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.UP));
        }
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return state.is(AtmosphericBlockTags.MONKEY_BRUSH_PLACEABLE);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos offsetPos = pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite());
        return this.mayPlaceOn(level.getBlockState(offsetPos), (BlockGetter)level, offsetPos);
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return context.getClickedFace().getAxis().isVertical() ? (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace()) : this.defaultBlockState();
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Vec3 vec3d = state.getOffset(level, pos);
        return SHAPE.move(vec3d.x, vec3d.y, vec3d.z);
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        for (BlockPos newPos : BlockPos.randomInCube((RandomSource)random, (int)64, (BlockPos)pos, (int)2)) {
            if (!MonkeyBrushBlock.attemptBrush((LevelAccessor)level, newPos, state)) continue;
            return;
        }
    }

    public static boolean attemptBrush(LevelAccessor level, BlockPos pos, BlockState state) {
        if (level.isEmptyBlock(pos) && pos.getY() < level.getMaxBuildHeight()) {
            ArrayList directions = Lists.newArrayList((Object[])Direction.values());
            Collections.shuffle(directions);
            for (Direction direction : directions) {
                BlockState newState = MonkeyBrushBlock.monkeyBrushState(state, direction);
                if (!newState.canSurvive((LevelReader)level, pos)) continue;
                level.setBlock(pos, newState, 2);
                return true;
            }
        }
        return false;
    }

    public static BlockState monkeyBrushState(BlockState state, Direction direction) {
        boolean isScalding;
        boolean isWarm = state.is(AtmosphericBlocks.WARM_MONKEY_BRUSH) || state.is(AtmosphericBlocks.WARM_WALL_MONKEY_BRUSH);
        boolean isHot = state.is(AtmosphericBlocks.HOT_MONKEY_BRUSH) || state.is(AtmosphericBlocks.HOT_WALL_MONKEY_BRUSH);
        boolean bl = isScalding = state.is(AtmosphericBlocks.SCALDING_MONKEY_BRUSH) || state.is(AtmosphericBlocks.SCALDING_WALL_MONKEY_BRUSH);
        if (isWarm) {
            state = ((Block)AtmosphericBlocks.WARM_MONKEY_BRUSH.get()).defaultBlockState();
        }
        if (isHot) {
            state = ((Block)AtmosphericBlocks.HOT_MONKEY_BRUSH.get()).defaultBlockState();
        }
        if (isScalding) {
            state = ((Block)AtmosphericBlocks.SCALDING_MONKEY_BRUSH.get()).defaultBlockState();
        }
        if (direction.getAxis().isVertical() && !(state.getBlock() instanceof WallMonkeyBrushBlock)) {
            return (BlockState)state.setValue((Property)FACING, (Comparable)direction);
        }
        if (isWarm) {
            state = ((Block)AtmosphericBlocks.WARM_WALL_MONKEY_BRUSH.get()).defaultBlockState();
        }
        if (isHot) {
            state = ((Block)AtmosphericBlocks.HOT_WALL_MONKEY_BRUSH.get()).defaultBlockState();
        }
        if (isScalding) {
            state = ((Block)AtmosphericBlocks.SCALDING_WALL_MONKEY_BRUSH.get()).defaultBlockState();
        }
        return (BlockState)state.setValue((Property)WallMonkeyBrushBlock.FACING, (Comparable)direction);
    }
}

