/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.block;

import com.mojang.serialization.MapCodec;
import com.teamabnormals.atmospheric.common.entity.OrangeVaporCloud;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class OrangeBlock
extends DirectionalBlock
implements SimpleWaterloggedBlock {
    public static final IntegerProperty ORANGES = IntegerProperty.create((String)"oranges", (int)1, (int)2);
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape SINGLE = Block.box((double)5.0, (double)0.0, (double)4.0, (double)12.0, (double)6.0, (double)11.0);
    private static final VoxelShape SINGLE_CEILING = Block.box((double)5.0, (double)8.0, (double)4.0, (double)12.0, (double)14.0, (double)11.0);
    private static final VoxelShape SINGLE_WALL = Block.box((double)5.0, (double)4.0, (double)9.0, (double)12.0, (double)10.0, (double)16.0);
    private static final VoxelShape DOUBLE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)6.0, (double)15.0);
    private static final VoxelShape DOUBLE_CEILING = Block.box((double)1.0, (double)8.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    private static final VoxelShape DOUBLE_WALL = Block.box((double)1.0, (double)0.0, (double)9.0, (double)16.0, (double)14.0, (double)16.0);
    private static final VoxelShape DOUBLE_COLLISION = Shapes.or((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)8.0, (double)6.0, (double)8.0), (VoxelShape)Block.box((double)8.0, (double)0.0, (double)8.0, (double)15.0, (double)6.0, (double)15.0));
    private static final VoxelShape DOUBLE_CEILING_COLLISION = Shapes.or((VoxelShape)Block.box((double)1.0, (double)8.0, (double)1.0, (double)8.0, (double)14.0, (double)8.0), (VoxelShape)Block.box((double)8.0, (double)8.0, (double)8.0, (double)15.0, (double)14.0, (double)15.0));
    private static final VoxelShape DOUBLE_WALL_COLLISION = Shapes.or((VoxelShape)Block.box((double)1.0, (double)0.0, (double)9.0, (double)8.0, (double)6.0, (double)16.0), (VoxelShape)Block.box((double)9.0, (double)8.0, (double)9.0, (double)16.0, (double)14.0, (double)16.0));

    public OrangeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)ORANGES, (Comparable)Integer.valueOf(1))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends DirectionalBlock> codec() {
        return null;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return OrangeBlock.canAttach(level, pos, ((Direction)state.getValue((Property)FACING)).getOpposite());
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        boolean single = (Integer)state.getValue((Property)ORANGES) < 2;
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.UP -> {
                if (single) {
                    yield SINGLE;
                }
                yield DOUBLE;
            }
            case Direction.DOWN -> {
                if (single) {
                    yield SINGLE_CEILING;
                }
                yield DOUBLE_CEILING;
            }
            default -> OrangeBlock.rotateShape(Direction.NORTH, (Direction)state.getValue((Property)FACING), single ? SINGLE_WALL : DOUBLE_WALL);
        };
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape voxelShape;
        if ((Integer)state.getValue((Property)ORANGES) < 2) {
            voxelShape = this.getShape(state, level, pos, context);
        } else {
            switch ((Direction)state.getValue((Property)FACING)) {
                case UP: {
                    voxelShape = DOUBLE_COLLISION;
                    break;
                }
                case DOWN: {
                    voxelShape = DOUBLE_CEILING_COLLISION;
                    break;
                }
                default: {
                    voxelShape = OrangeBlock.rotateShape(Direction.NORTH, (Direction)state.getValue((Property)FACING), DOUBLE_WALL_COLLISION);
                }
            }
        }
        return voxelShape;
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.empty()};
        int times = (to.get2DDataValue() - from.get2DDataValue() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.or((VoxelShape)buffer[1], (VoxelShape)Shapes.create((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.empty();
        }
        return buffer[0];
    }

    public static boolean canAttach(LevelReader level, BlockPos pos, Direction direction) {
        BlockPos relativePos = pos.relative(direction);
        return level.getBlockState(relativePos).isFaceSturdy((BlockGetter)level, relativePos, direction.getOpposite()) || level.getBlockState(relativePos).is(BlockTags.LEAVES);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState offsetState, LevelAccessor level, BlockPos pos, BlockPos offsetPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return ((Direction)state.getValue((Property)FACING)).getOpposite() == direction && !state.canSurvive((LevelReader)level, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, offsetState, level, pos, offsetPos);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean flag;
        BlockState state = context.getLevel().getBlockState(context.getClickedPos());
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        boolean bl = flag = fluidState.getType() == Fluids.WATER;
        if (state.is((Block)this)) {
            return (BlockState)state.cycle((Property)ORANGES);
        }
        for (Direction direction : context.getNearestLookingDirections()) {
            BlockState newState = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction.getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
            if (!newState.canSurvive((LevelReader)context.getLevel(), context.getClickedPos())) continue;
            return newState;
        }
        return null;
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float distance) {
        if (!level.isClientSide) {
            if ((Integer)state.getValue((Property)ORANGES) < 2) {
                level.destroyBlock(pos, false);
            } else {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ORANGES, (Comparable)Integer.valueOf(1)));
                level.levelEvent(2001, pos, Block.getId((BlockState)state));
            }
            OrangeBlock.createVaporCloud(level, new Vec3((double)((float)pos.getX() + 0.5f), (double)pos.getY(), (double)((float)pos.getZ() + 0.5f)), state.is((Block)AtmosphericBlocks.BLOOD_ORANGE.get()));
        }
        super.fallOn(level, state, pos, entity, distance);
    }

    public static void createVaporCloud(Level level, Vec3 pos, boolean blood) {
        OrangeVaporCloud cloud = new OrangeVaporCloud(level, pos.x(), pos.y(), pos.z());
        cloud.setBloodOrange(blood);
        cloud.setRadius(1.5f);
        cloud.setDuration(600);
        cloud.setRadiusPerTick(-cloud.getRadius() / (float)cloud.getDuration());
        level.addFreshEntity((Entity)cloud);
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        return context.getItemInHand().getItem() == this.asItem() && (Integer)state.getValue((Property)ORANGES) < 2 || super.canBeReplaced(state, context);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, ORANGES, WATERLOGGED});
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return state.getFluidState().isEmpty();
    }
}

